/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.utils;

import io.proximax.utils.ParameterValidationUtils;
import java.security.SecureRandom;

public class PasswordUtils {
    private static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String SPECIAL_CHARACTERS = "~!@#$%^&*()-_=+[]{};:'\",./<>?";

    public static String generatePassword() {
        return PasswordUtils.generatePassword(10);
    }

    public static String generatePassword(int length) {
        return PasswordUtils.generatePassword(length, false);
    }

    public static String generatePassword(boolean allowSpecialCharacters) {
        return PasswordUtils.generatePassword(10, allowSpecialCharacters);
    }

    public static String generatePassword(int length, boolean allowSpecialCharacters) {
        ParameterValidationUtils.checkParameter(length >= 10, String.format("Password length should be longer than %d. %d was provided", 10, length));
        SecureRandom random = new SecureRandom();
        String allowedCharacters = allowSpecialCharacters ? "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789~!@#$%^&*()-_=+[]{};:'\",./<>?" : ALPHA_NUMERIC;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(allowedCharacters.length());
            stringBuilder.append(allowedCharacters.charAt(index));
        }
        return stringBuilder.toString();
    }
}

