/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.utils;

import io.proximax.core.crypto.KeyPair;
import io.proximax.sdk.model.account.Account;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.blockchain.NetworkType;
import io.proximax.sdk.model.transaction.SignedTransaction;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.utils.ParameterValidationUtils;

public class NemUtils {
    private final NetworkType networkType;

    public NemUtils(NetworkType networkType) {
        this.networkType = networkType;
    }

    public Address getAddress(String address) {
        ParameterValidationUtils.checkParameter(address != null, "address is required");
        return Address.createFromRawAddress((String)address);
    }

    public Address getAddressFromPublicKey(String publicKey) {
        ParameterValidationUtils.checkParameter(publicKey != null, "publicKey is required");
        return Address.createFromPublicKey((String)publicKey, (NetworkType)this.networkType);
    }

    public Address getAddressFromPrivateKey(String privateKey) {
        ParameterValidationUtils.checkParameter(privateKey != null, "privateKey is required");
        return this.getAccount(privateKey).getAddress();
    }

    public Account getAccount(String privateKey) {
        ParameterValidationUtils.checkParameter(privateKey != null, "privateKey is required");
        return Account.createFromPrivateKey((String)privateKey, (NetworkType)this.networkType);
    }

    public Account generateAccount() {
        KeyPair kp = new KeyPair();
        Account account = new Account(kp, this.networkType);
        return account;
    }

    public SignedTransaction signTransaction(String signerPrivateKey, Transaction transaction) {
        ParameterValidationUtils.checkParameter(signerPrivateKey != null, "signerPrivateKey is required");
        ParameterValidationUtils.checkParameter(transaction != null, "transaction is required");
        return this.getAccount(signerPrivateKey).sign(transaction);
    }
}

