/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.utils;

import io.proximax.exceptions.DigestCalculationFailureException;
import io.proximax.exceptions.DigestDoesNotMatchException;
import io.proximax.utils.ParameterValidationUtils;
import java.io.IOException;
import java.io.InputStream;

public class DigestUtils {
    private DigestUtils() {
    }

    public static String digest(InputStream inputStream) {
        ParameterValidationUtils.checkParameter(inputStream != null, "byteStream is required");
        return DigestUtils.encodeData(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateDigest(InputStream inputStream, String expectedDigest) {
        ParameterValidationUtils.checkParameter(inputStream != null, "inputStream is required");
        if (expectedDigest == null) return true;
        try (InputStream stream = inputStream;){
            String actualDigest = DigestUtils.digest(stream);
            if (!actualDigest.equals(expectedDigest)) {
                throw new DigestDoesNotMatchException(String.format("Data digests do not match (actual: %s, expected %s)", actualDigest, expectedDigest));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to calculate digest of stream", e);
        }
    }

    private static String encodeData(InputStream byteStream) {
        try {
            return org.apache.commons.codec.digest.DigestUtils.sha256Hex((InputStream)byteStream);
        }
        catch (IOException e) {
            throw new DigestCalculationFailureException("Digest calculation failed", e);
        }
    }
}

