/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.utils;

import io.proximax.exceptions.DetectContenTypeFailureException;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.Tika;

public class ContentTypeUtils {
    private Tika tika = new Tika();

    public Observable<String> detectContentType(InputStream byteStream) {
        ParameterValidationUtils.checkParameter(byteStream != null, "byteStream is required");
        try {
            return Observable.just((Object)this.tika.detect(byteStream));
        }
        catch (IOException e) {
            throw new DetectContenTypeFailureException("Failed to detect content type", e);
        }
    }
}

