/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.exceptions.GetByteStreamFailureException;
import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class UrlResourceParameterData
extends AbstractByteStreamParameterData {
    private final URL url;

    private UrlResourceParameterData(URL url, String description, String name, String contentType, Map<String, String> metadata) {
        super(description, name, contentType, metadata);
        ParameterValidationUtils.checkParameter(url != null, "url is required");
        this.url = url;
    }

    @Override
    public InputStream getByteStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new GetByteStreamFailureException("Failed to open byte stream", e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public static UrlResourceParameterData create(URL url) {
        return UrlResourceParameterData.create(url, null, null, null, null);
    }

    public static UrlResourceParameterData create(URL url, String description, String name, String contentType, Map<String, String> metadata) {
        return new UrlResourceParameterData(url, description, name, contentType, metadata);
    }
}

