/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.async.AsyncCallbacks;
import io.proximax.async.AsyncTask;
import io.proximax.connection.ConnectionConfig;
import io.proximax.exceptions.UploadFailureException;
import io.proximax.exceptions.UploadInitFailureException;
import io.proximax.model.ProximaxDataModel;
import io.proximax.model.ProximaxMessagePayloadModel;
import io.proximax.service.BlockchainTransactionService;
import io.proximax.service.CreateProximaxDataService;
import io.proximax.service.CreateProximaxMessagePayloadService;
import io.proximax.upload.UploadParameter;
import io.proximax.upload.UploadResult;
import io.proximax.utils.AsyncUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.net.MalformedURLException;

public class Uploader {
    private final BlockchainTransactionService blockchainTransactionService;
    private final CreateProximaxDataService createProximaxDataService;
    private final CreateProximaxMessagePayloadService createProximaxMessagePayloadService;

    public Uploader(ConnectionConfig connectionConfig) {
        this.createProximaxDataService = new CreateProximaxDataService(connectionConfig.getFileStorageConnection());
        this.createProximaxMessagePayloadService = new CreateProximaxMessagePayloadService();
        try {
            this.blockchainTransactionService = new BlockchainTransactionService(connectionConfig.getBlockchainNetworkConnection());
        }
        catch (MalformedURLException e) {
            throw new UploadInitFailureException("Failed to initialize", e);
        }
    }

    Uploader(BlockchainTransactionService blockchainTransactionService, CreateProximaxDataService createProximaxDataService, CreateProximaxMessagePayloadService createProximaxMessagePayloadService) {
        this.blockchainTransactionService = blockchainTransactionService;
        this.createProximaxDataService = createProximaxDataService;
        this.createProximaxMessagePayloadService = createProximaxMessagePayloadService;
    }

    public UploadResult upload(UploadParameter uploadParam) {
        ParameterValidationUtils.checkParameter(uploadParam != null, "uploadParam is required");
        return (UploadResult)this.doUpload(uploadParam).blockingFirst();
    }

    public AsyncTask uploadAsync(UploadParameter uploadParam, AsyncCallbacks<UploadResult> asyncCallbacks) {
        ParameterValidationUtils.checkParameter(uploadParam != null, "uploadParam is required");
        AsyncTask asyncTask = new AsyncTask();
        AsyncUtils.processFirstItem(this.doUpload(uploadParam).subscribeOn(Schedulers.newThread()), asyncCallbacks, asyncTask);
        return asyncTask;
    }

    private Observable<UploadResult> doUpload(UploadParameter uploadParam) {
        return Observable.fromCallable(() -> {
            try {
                UploadResult result = (UploadResult)this.createProximaxDataService.createData(uploadParam).flatMap(uploadedData -> this.createProximaxMessagePayloadService.createMessagePayload(uploadParam, (ProximaxDataModel)uploadedData).flatMap(messagePayload -> this.createAndAnnounceTransaction(uploadParam, (ProximaxMessagePayloadModel)messagePayload).map(transactionHash -> this.createUploadResult((ProximaxMessagePayloadModel)messagePayload, (String)transactionHash)))).blockingFirst();
                return result;
            }
            catch (RuntimeException ex) {
                throw new UploadFailureException("Upload failed.", ex);
            }
        });
    }

    private Observable<String> createAndAnnounceTransaction(UploadParameter uploadParam, ProximaxMessagePayloadModel messagePayload) {
        return this.blockchainTransactionService.createAndAnnounceTransaction(messagePayload, uploadParam.getSignerPrivateKey(), uploadParam.getRecipientPublicKey(), uploadParam.getRecipientAddress(), uploadParam.getTransactionDeadline(), uploadParam.getTransactionMosaics(), uploadParam.getUseBlockchainSecureMessage());
    }

    private UploadResult createUploadResult(ProximaxMessagePayloadModel messagePayload, String transactionHash) {
        return UploadResult.create(transactionHash, messagePayload.getPrivacyType(), messagePayload.getVersion(), messagePayload.getData());
    }
}

