/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.model.DataInfoModel;
import io.proximax.utils.JsonUtils;
import io.proximax.utils.ParameterValidationUtils;
import java.util.Map;

public abstract class UploadParameterData
extends DataInfoModel {
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MAX_CONTENT_TYPE_LENGTH = 30;
    public static final int MAX_METADATA_JSON_LENGTH = 400;

    UploadParameterData(String description, String name, String contentType, Map<String, String> metadata) {
        super(description, name, contentType, metadata);
        ParameterValidationUtils.checkParameter(description == null || description.length() <= 100, String.format("description cannot be more than %d characters", 100));
        ParameterValidationUtils.checkParameter(name == null || name.length() <= 100, String.format("name cannot be more than %d characters", 100));
        ParameterValidationUtils.checkParameter(contentType == null || contentType.length() <= 30, String.format("contentType cannot be more than %d characters", 30));
        ParameterValidationUtils.checkParameter(metadata == null || JsonUtils.toJson(metadata).length() <= 400, String.format("metadata as JSON string cannot be more than %d characters", 400));
    }
}

