/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.core.crypto.PrivateKey;
import io.proximax.core.crypto.PublicKey;
import io.proximax.privacy.strategy.NemKeysPrivacyStrategy;
import io.proximax.privacy.strategy.PasswordPrivacyStrategy;
import io.proximax.privacy.strategy.PlainPrivacyStrategy;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.mosaic.Mosaic;
import io.proximax.upload.UploadParameter;
import io.proximax.upload.UploadParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.util.List;

public class UploadParameterBuilder {
    private final UploadParameterData data;
    private final String signerPrivateKey;
    private String recipientPublicKey;
    private String recipientAddress;
    private Boolean computeDigest;
    private Boolean detectContentType;
    private Integer transactionDeadline;
    private List<Mosaic> transactionMosaics;
    private Boolean useBlockchainSecureMessage;
    private PrivacyStrategy privacyStrategy;

    public UploadParameterBuilder(UploadParameterData data, String signerPrivateKey) {
        ParameterValidationUtils.checkParameter(data != null, "data is required");
        ParameterValidationUtils.checkParameter(signerPrivateKey != null, "signerPrivateKey is required");
        ParameterValidationUtils.checkParameter(() -> PrivateKey.fromHexString((String)signerPrivateKey) != null, "signerPrivateKey should be a valid private key");
        this.data = data;
        this.signerPrivateKey = signerPrivateKey;
    }

    public UploadParameterBuilder withRecipientPublicKey(String recipientPublicKey) {
        ParameterValidationUtils.checkParameter(() -> recipientPublicKey == null || PublicKey.fromHexString((String)recipientPublicKey) != null, "recipientPublicKey should be a valid public key");
        this.recipientPublicKey = recipientPublicKey;
        return this;
    }

    public UploadParameterBuilder withRecipientAddress(String recipientAddress) {
        ParameterValidationUtils.checkParameter(() -> recipientAddress == null || Address.createFromRawAddress((String)recipientAddress) != null, "recipientAddress should be a valid address");
        this.recipientAddress = recipientAddress;
        return this;
    }

    public UploadParameterBuilder withComputeDigest(Boolean computeDigest) {
        this.computeDigest = computeDigest;
        return this;
    }

    public UploadParameterBuilder withDetectContentType(Boolean detectContentType) {
        this.detectContentType = detectContentType;
        return this;
    }

    public UploadParameterBuilder withUseBlockchainSecureMessage(Boolean useBlockchainSecureMessage) {
        this.useBlockchainSecureMessage = useBlockchainSecureMessage;
        return this;
    }

    public UploadParameterBuilder withTransactionDeadline(Integer transactionDeadline) {
        ParameterValidationUtils.checkParameter(transactionDeadline == null || transactionDeadline >= 1 && transactionDeadline <= 23, "transactionDeadline should be between 1 and 23");
        this.transactionDeadline = transactionDeadline;
        return this;
    }

    public UploadParameterBuilder withTransactionMosaic(List<Mosaic> transactionMosaics) {
        this.transactionMosaics = transactionMosaics;
        return this;
    }

    public UploadParameterBuilder withPrivacyStrategy(PrivacyStrategy privacyStrategy) {
        this.privacyStrategy = privacyStrategy;
        return this;
    }

    public UploadParameterBuilder withPlainPrivacy() {
        this.privacyStrategy = PlainPrivacyStrategy.create();
        return this;
    }

    public UploadParameterBuilder withNemKeysPrivacy(String privateKey, String publicKey) {
        this.privacyStrategy = NemKeysPrivacyStrategy.create(privateKey, publicKey);
        return this;
    }

    public UploadParameterBuilder withPasswordPrivacy(String password) {
        this.privacyStrategy = PasswordPrivacyStrategy.create(password);
        return this;
    }

    public UploadParameter build() {
        if (this.computeDigest == null) {
            this.computeDigest = false;
        }
        if (this.detectContentType == null) {
            this.detectContentType = false;
        }
        if (this.transactionDeadline == null) {
            this.transactionDeadline = 12;
        }
        if (this.useBlockchainSecureMessage == null) {
            this.useBlockchainSecureMessage = false;
        }
        if (this.privacyStrategy == null) {
            this.privacyStrategy = PlainPrivacyStrategy.create();
        }
        return new UploadParameter(this.data, this.signerPrivateKey, this.recipientPublicKey, this.recipientAddress, this.computeDigest, this.detectContentType, this.transactionDeadline, this.transactionMosaics, this.useBlockchainSecureMessage, this.privacyStrategy);
    }
}

