/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.sdk.model.mosaic.Mosaic;
import io.proximax.upload.ByteArrayParameterData;
import io.proximax.upload.FileParameterData;
import io.proximax.upload.FilesAsZipParameterData;
import io.proximax.upload.InputStreamParameterData;
import io.proximax.upload.PathParameterData;
import io.proximax.upload.StringParameterData;
import io.proximax.upload.UploadParameterBuilder;
import io.proximax.upload.UploadParameterData;
import io.proximax.upload.UrlResourceParameterData;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class UploadParameter {
    private final UploadParameterData data;
    private final String signerPrivateKey;
    private final String recipientPublicKey;
    private final String recipientAddress;
    private final boolean computeDigest;
    private final boolean detectContentType;
    private final int transactionDeadline;
    private final List<Mosaic> transactionMosaics;
    private final boolean useBlockchainSecureMessage;
    private final PrivacyStrategy privacyStrategy;
    private final String version;

    UploadParameter(UploadParameterData data, String signerPrivateKey, String recipientPublicKey, String recipientAddress, boolean computeDigest, boolean detectContentType, int transactionDeadline, List<Mosaic> transactionMosaics, boolean useBlockchainSecureMessage, PrivacyStrategy privacyStrategy) {
        this.data = data;
        this.signerPrivateKey = signerPrivateKey;
        this.recipientPublicKey = recipientPublicKey;
        this.recipientAddress = recipientAddress;
        this.computeDigest = computeDigest;
        this.detectContentType = detectContentType;
        this.transactionDeadline = transactionDeadline;
        this.transactionMosaics = transactionMosaics == null ? null : Collections.unmodifiableList(transactionMosaics);
        this.useBlockchainSecureMessage = useBlockchainSecureMessage;
        this.privacyStrategy = privacyStrategy;
        this.version = "1.0";
    }

    public UploadParameterData getData() {
        return this.data;
    }

    public String getSignerPrivateKey() {
        return this.signerPrivateKey;
    }

    public String getRecipientPublicKey() {
        return this.recipientPublicKey;
    }

    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public boolean getComputeDigest() {
        return this.computeDigest;
    }

    public boolean getDetectContentType() {
        return this.detectContentType;
    }

    public int getTransactionDeadline() {
        return this.transactionDeadline;
    }

    public List<Mosaic> getTransactionMosaics() {
        return this.transactionMosaics;
    }

    public boolean getUseBlockchainSecureMessage() {
        return this.useBlockchainSecureMessage;
    }

    public PrivacyStrategy getPrivacyStrategy() {
        return this.privacyStrategy;
    }

    public String getVersion() {
        return this.version;
    }

    public static UploadParameterBuilder createForFileUpload(File file, String signerPrivateKey) {
        return UploadParameter.createForFileUpload(FileParameterData.create(file), signerPrivateKey);
    }

    public static UploadParameterBuilder createForFileUpload(FileParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForByteArrayUpload(byte[] bytes, String signerPrivateKey) {
        return UploadParameter.createForByteArrayUpload(ByteArrayParameterData.create(bytes), signerPrivateKey);
    }

    public static UploadParameterBuilder createForByteArrayUpload(ByteArrayParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForStringUpload(String string, String signerPrivateKey) {
        return UploadParameter.createForStringUpload(StringParameterData.create(string), signerPrivateKey);
    }

    public static UploadParameterBuilder createForStringUpload(StringParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForUrlResourceUpload(URL url, String signerPrivateKey) {
        return UploadParameter.createForUrlResourceUpload(UrlResourceParameterData.create(url), signerPrivateKey);
    }

    public static UploadParameterBuilder createForUrlResourceUpload(UrlResourceParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForInputStreamUpload(Supplier<InputStream> inputStreamSupplier, String signerPrivateKey) {
        return UploadParameter.createForInputStreamUpload(InputStreamParameterData.create(inputStreamSupplier), signerPrivateKey);
    }

    public static UploadParameterBuilder createForInputStreamUpload(InputStreamParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForFilesAsZipUpload(List<File> files, String signerPrivateKey) {
        return UploadParameter.createForFilesAsZipUpload(FilesAsZipParameterData.create(files), signerPrivateKey);
    }

    public static UploadParameterBuilder createForFilesAsZipUpload(FilesAsZipParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }

    public static UploadParameterBuilder createForPathUpload(File path, String signerPrivateKey) {
        return UploadParameter.createForPathUpload(PathParameterData.create(path), signerPrivateKey);
    }

    public static UploadParameterBuilder createForPathUpload(PathParameterData parameterData, String signerPrivateKey) {
        return new UploadParameterBuilder(parameterData, signerPrivateKey);
    }
}

