/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.exceptions.ParamDataCreationException;
import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class StringParameterData
extends AbstractByteStreamParameterData {
    private final String string;
    private final byte[] stringData;

    private StringParameterData(String string, String encoding, String description, String name, String contentType, Map<String, String> metadata) {
        super(description, name, contentType, metadata);
        ParameterValidationUtils.checkParameter(string != null, "string is required");
        this.string = string;
        this.stringData = this.toStringByteArray(string, encoding);
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.stringData);
    }

    public String getString() {
        return this.string;
    }

    private byte[] toStringByteArray(String string, String encoding) {
        try {
            return encoding == null ? string.getBytes() : string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParamDataCreationException("Failed to convert string to bytes", e);
        }
    }

    public static StringParameterData create(String string) {
        return StringParameterData.create(string, null, null, null, null, null);
    }

    public static StringParameterData create(String string, String encoding, String description, String name, String contentType, Map<String, String> metadata) {
        return new StringParameterData(string, encoding, description, name, contentType, metadata);
    }
}

