/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.exceptions.ParamDataCreationException;
import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class FilesAsZipParameterData
extends AbstractByteStreamParameterData {
    private final List<File> files;
    private final byte[] zipData;

    private FilesAsZipParameterData(List<File> files, String description, String name, Map<String, String> metadata) {
        super(description, name, "application/zip", metadata);
        ParameterValidationUtils.checkParameter(files != null && !files.isEmpty(), "files cannot be null or empty");
        ParameterValidationUtils.checkParameter(files.stream().allMatch(File::isFile), "not all files are file");
        this.files = files;
        this.zipData = FilesAsZipParameterData.zipFiles(files);
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.zipData);
    }

    public List<File> getFiles() {
        return this.files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zipFiles(List<File> files) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            for (File file : files) {
                ZipEntry entry = new ZipEntry(file.getName());
                zos.putNextEntry(entry);
                zos.write(FileUtils.readFileToByteArray((File)file));
                zos.closeEntry();
            }
            Object object = baos.toByteArray();
            return object;
        }
        catch (Exception e) {
            throw new ParamDataCreationException("Failed to create zip file", e);
        }
    }

    public static FilesAsZipParameterData create(List<File> files) {
        return FilesAsZipParameterData.create(files, null, null, null);
    }

    public static FilesAsZipParameterData create(List<File> files, String description, String name, Map<String, String> metadata) {
        return new FilesAsZipParameterData(files, description, name, metadata);
    }
}

