/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.exceptions.GetByteStreamFailureException;
import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class FileParameterData
extends AbstractByteStreamParameterData {
    private final File file;

    private FileParameterData(File file, String description, String name, String contentType, Map<String, String> metadata) {
        super(description, FileParameterData.getDefaultName(file, name), contentType, metadata);
        ParameterValidationUtils.checkParameter(file != null, "file is required");
        ParameterValidationUtils.checkParameter(file.isFile(), "file is not file");
        this.file = file;
    }

    @Override
    public InputStream getByteStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new GetByteStreamFailureException("Failed to open byte stream", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public static FileParameterData create(File file) {
        return FileParameterData.create(file, null, null, null, null);
    }

    public static FileParameterData create(File file, String description, String name, String contentType, Map<String, String> metadata) {
        return new FileParameterData(file, description, name, contentType, metadata);
    }

    private static String getDefaultName(File file, String name) {
        return name == null && file != null ? file.getName() : name;
    }
}

