/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.upload;

import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.utils.ParameterValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class ByteArrayParameterData
extends AbstractByteStreamParameterData {
    private final byte[] data;

    protected ByteArrayParameterData(byte[] data, String description, String name, String contentType, Map<String, String> metadata) {
        super(description, name, contentType, metadata);
        ParameterValidationUtils.checkParameter(data != null, "data is required");
        this.data = data;
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public static ByteArrayParameterData create(byte[] data) {
        return ByteArrayParameterData.create(data, null, null, null, null);
    }

    public static ByteArrayParameterData create(byte[] data, String description, String name, String contentType, Map<String, String> metadata) {
        return new ByteArrayParameterData(data, description, name, contentType, metadata);
    }
}

