/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service.factory;

import io.proximax.connection.FileStorageConnection;
import io.proximax.connection.IpfsConnection;
import io.proximax.connection.StorageConnection;
import io.proximax.service.client.IpfsClient;
import io.proximax.service.client.StorageNodeClient;
import io.proximax.service.repository.FileRepository;
import io.proximax.utils.ParameterValidationUtils;

public class FileRepositoryFactory {
    private FileRepositoryFactory() {
    }

    public static FileRepository create(FileStorageConnection fileStorageConnection) {
        ParameterValidationUtils.checkParameter(fileStorageConnection != null, "fileStorageConnection is required");
        if (fileStorageConnection instanceof IpfsConnection) {
            return new IpfsClient((IpfsConnection)fileStorageConnection);
        }
        if (fileStorageConnection instanceof StorageConnection) {
            return new StorageNodeClient((StorageConnection)fileStorageConnection);
        }
        throw new IllegalArgumentException(String.format("Unknown file storage connection %s", fileStorageConnection.getClass().getSimpleName()));
    }
}

