/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service.client.catapult;

import io.proximax.connection.BlockchainNetworkConnection;
import io.proximax.exceptions.AnnounceBlockchainTransactionFailureException;
import io.proximax.sdk.BlockchainApi;
import io.proximax.sdk.infrastructure.Listener;
import io.proximax.sdk.infrastructure.TransactionHttp;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.transaction.SignedTransaction;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.sdk.model.transaction.TransactionInfo;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.net.MalformedURLException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class TransactionClient {
    public static final String STATUS_FOR_SUCCESSFUL_UNCONFIRMED_TRANSACTION = "SUCCESS";
    private final TransactionHttp transactionHttp;
    private final String blockchainNetworkRestApiUrl;
    private final Listener listener;
    private final BlockchainApi blockchainApi;

    public TransactionClient(BlockchainNetworkConnection blockchainNetworkConnection) throws MalformedURLException {
        ParameterValidationUtils.checkParameter(blockchainNetworkConnection != null, "blockchainNetworkConnection is required");
        this.blockchainApi = blockchainNetworkConnection.getBlockchainApi();
        this.transactionHttp = (TransactionHttp)this.blockchainApi.createTransactionRepository();
        this.blockchainNetworkRestApiUrl = blockchainNetworkConnection.getApiUrl();
        this.listener = null;
    }

    TransactionClient(TransactionHttp transactionHttp, Listener listener) {
        this.transactionHttp = transactionHttp;
        this.blockchainNetworkRestApiUrl = null;
        this.blockchainApi = null;
        this.listener = listener;
    }

    public synchronized String announce(SignedTransaction signedTransaction, Address address) {
        ParameterValidationUtils.checkParameter(signedTransaction != null, "signedTransaction is required");
        ParameterValidationUtils.checkParameter(address != null, "address is required");
        Listener listener = this.getListener();
        try {
            listener.open().get(10L, TimeUnit.SECONDS);
            Observable<String> failedTransactionStatusOb = this.getAddedFailedTransactionStatus(address, signedTransaction.getHash(), listener);
            Observable<String> unconfirmedTransactionStatusOb = this.getAddedUnconfirmedTransactionStatus(address, signedTransaction.getHash(), listener);
            Future statusFuture = failedTransactionStatusOb.mergeWith(unconfirmedTransactionStatusOb).map(status -> {
                if (status.equals(STATUS_FOR_SUCCESSFUL_UNCONFIRMED_TRANSACTION)) {
                    return status;
                }
                throw new AnnounceBlockchainTransactionFailureException(String.format("Failed to announce transaction with status %s", status));
            }).take(1L).toFuture();
            this.transactionHttp.announce(signedTransaction).blockingFirst();
            String string = (String)statusFuture.get(60L, TimeUnit.SECONDS);
            return string;
        }
        catch (AnnounceBlockchainTransactionFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AnnounceBlockchainTransactionFailureException("Failed to announce transaction", ex);
        }
        finally {
            this.closeListener(listener);
        }
    }

    public Observable<Transaction> getTransaction(String transactionHash) {
        ParameterValidationUtils.checkParameter(transactionHash != null, "transactionHash is required");
        return this.transactionHttp.getTransaction(transactionHash);
    }

    private Listener getListener() {
        return this.listener != null ? this.listener : (Listener)this.blockchainApi.createListener();
    }

    private Observable<String> getAddedUnconfirmedTransactionStatus(Address address, String transactionHash, Listener listener) {
        return listener.unconfirmedAdded(address).filter(unconfirmedTxn -> unconfirmedTxn.getTransactionInfo().flatMap(TransactionInfo::getHash).map(hash -> hash.equals(transactionHash)).orElse(false)).map(unconfirmedTxn -> STATUS_FOR_SUCCESSFUL_UNCONFIRMED_TRANSACTION);
    }

    private Observable<String> getAddedFailedTransactionStatus(Address address, String transactionHash, Listener listener) {
        return listener.status(address).filter(transactionStatusError -> transactionStatusError.getHash().equals(transactionHash)).map(transactionStatusError -> transactionStatusError.getStatus());
    }

    private void closeListener(Listener listener) {
        try {
            listener.close();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

