/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service.client.catapult;

import io.proximax.connection.BlockchainNetworkConnection;
import io.proximax.core.crypto.PublicKey;
import io.proximax.exceptions.AccountNotFoundException;
import io.proximax.exceptions.PublicKeyNotFoundException;
import io.proximax.model.TransactionFilter;
import io.proximax.sdk.infrastructure.AccountHttp;
import io.proximax.sdk.infrastructure.QueryParams;
import io.proximax.sdk.model.account.AccountInfo;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.account.PublicAccount;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.net.MalformedURLException;
import java.util.List;

public class AccountClient {
    public static final String PUBLIC_KEY_NOT_FOUND = "0000000000000000000000000000000000000000000000000000000000000000";
    private final AccountHttp accountHttp;

    public AccountClient(BlockchainNetworkConnection blockchainNetworkConnection) throws MalformedURLException {
        ParameterValidationUtils.checkParameter(blockchainNetworkConnection != null, "blockchainNetworkConnection is required");
        this.accountHttp = (AccountHttp)blockchainNetworkConnection.getBlockchainApi().createAccountRepository();
    }

    AccountClient(AccountHttp accountHttp) {
        this.accountHttp = accountHttp;
    }

    public PublicKey getPublicKey(String address) {
        ParameterValidationUtils.checkParameter(address != null, "address is required.");
        try {
            AccountInfo accountInfo = (AccountInfo)this.accountHttp.getAccountInfo(Address.createFromRawAddress((String)address)).blockingFirst();
            if (accountInfo.getPublicKey().equals(PUBLIC_KEY_NOT_FOUND)) {
                throw new PublicKeyNotFoundException(String.format("Address %s has no public key yet on blockchain", address));
            }
            return PublicKey.fromHexString((String)accountInfo.getPublicKey());
        }
        catch (PublicKeyNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new AccountNotFoundException(String.format("Failed to retrieve account for %s. Probably address is not yet revealed on blockchain.", address), e);
        }
    }

    public Observable<List<Transaction>> getTransactions(TransactionFilter transactionFilter, int resultSize, PublicAccount publicAccount, String fromTransactionId) {
        ParameterValidationUtils.checkParameter(transactionFilter != null, "transactionFilter is required");
        QueryParams queryParams = new QueryParams(Integer.valueOf(resultSize), fromTransactionId);
        if (transactionFilter == TransactionFilter.ALL) {
            return this.accountHttp.transactions(publicAccount, queryParams);
        }
        if (transactionFilter == TransactionFilter.OUTGOING) {
            return this.accountHttp.outgoingTransactions(publicAccount, queryParams);
        }
        if (transactionFilter == TransactionFilter.INCOMING) {
            return this.accountHttp.incomingTransactions(publicAccount, queryParams);
        }
        throw new IllegalArgumentException(String.format("Unknown transactionFilter %s", transactionFilter.name()));
    }
}

