/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.proximax.connection.HttpProtocol;
import io.proximax.connection.StorageConnection;
import io.proximax.exceptions.UploadPathNotSupportedException;
import io.proximax.model.BlockchainNetworkType;
import io.proximax.service.repository.FileRepository;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.File;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class StorageNodeClient
implements FileRepository {
    public static final String HEADER_CREDENTIALS = "HeaderCredentials";
    private final String apiUrl;
    private final String headerCredentials;
    private final ObjectMapper objectMapper;

    public StorageNodeClient(StorageConnection storageConnection) {
        ParameterValidationUtils.checkParameter(storageConnection != null, "storageConnection is required");
        this.apiUrl = storageConnection.getApiUrl();
        this.headerCredentials = String.format("NemAddress=%s; Bearer %s", storageConnection.getNemAddress(), storageConnection.getBearerToken());
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public Observable<String> addByteStream(InputStream byteStream) {
        ParameterValidationUtils.checkParameter(byteStream != null, "byteStream is required");
        return Observable.fromCallable(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public Observable<String> addPath(File path) {
        return Observable.error((Throwable)new UploadPathNotSupportedException("Path upload is not supported on storage"));
    }

    @Override
    public Observable<InputStream> getByteStream(String dataHash) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        return Observable.fromCallable(() -> {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(new URIBuilder(this.apiUrl + "/download/file").addParameter("dataHash", dataHash).build());
            httpGet.setHeader(HEADER_CREDENTIALS, this.headerCredentials);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            return response.getEntity().getContent();
        });
    }

    public Observable<NodeInfoResponse> getNodeInfo() {
        return Observable.fromCallable(() -> {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpGet httpGet = new HttpGet(this.apiUrl + "/node/info");
                httpGet.setHeader(HEADER_CREDENTIALS, this.headerCredentials);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                NodeInfoResponse nodeInfoResponse = (NodeInfoResponse)this.objectMapper.readValue(response.getEntity().getContent(), NodeInfoResponse.class);
                return nodeInfoResponse;
            }
        });
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NodeInfoResponseBlockchainNetwork {
        private final HttpProtocol protocol;
        private final int port;
        private final String host;
        private final BlockchainNetworkType networkType;

        public NodeInfoResponseBlockchainNetwork(@JsonProperty(value="protocol") String protocol, @JsonProperty(value="port") int port, @JsonProperty(value="host") String host, @JsonProperty(value="network") String networkType) {
            this.protocol = HttpProtocol.fromString(protocol);
            this.port = port;
            this.host = host;
            this.networkType = BlockchainNetworkType.fromString(networkType);
        }

        public HttpProtocol getProtocol() {
            return this.protocol;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public BlockchainNetworkType getNetworkType() {
            return this.networkType;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NodeInfoResponse {
        private final NodeInfoResponseBlockchainNetwork blockchainNetwork;

        public NodeInfoResponse(@JsonProperty(value="blockchainNetwork") NodeInfoResponseBlockchainNetwork blockchainNetwork) {
            this.blockchainNetwork = blockchainNetwork;
        }

        public NodeInfoResponseBlockchainNetwork getBlockchainNetwork() {
            return this.blockchainNetwork;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UploadFileResponse {
        private final String dataHash;

        public UploadFileResponse(@JsonProperty(value="dataHash") String dataHash) {
            this.dataHash = dataHash;
        }

        static /* synthetic */ String access$000(UploadFileResponse x0) {
            return x0.dataHash;
        }
    }
}

