/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service.client;

import io.ipfs.api.MerkleNode;
import io.ipfs.api.NamedStreamable;
import io.ipfs.multihash.Multihash;
import io.proximax.connection.IpfsConnection;
import io.proximax.exceptions.IpfsClientFailureException;
import io.proximax.service.repository.FileRepository;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;

public class IpfsClient
implements FileRepository {
    private final IpfsConnection ipfsConnection;

    public IpfsClient(IpfsConnection ipfsConnection) {
        ParameterValidationUtils.checkParameter(ipfsConnection != null, "ipfsConnection is required");
        this.ipfsConnection = ipfsConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Observable<String> addByteStream(InputStream byteStream) {
        ParameterValidationUtils.checkParameter(byteStream != null, "byteStream is required");
        try (InputStream stream = byteStream;){
            List merkleNodes = (List)Observable.just((Object)stream).observeOn(Schedulers.io()).map(inputStream -> this.ipfsConnection.getIpfs().add((NamedStreamable)new NamedStreamable.InputStreamWrapper(inputStream))).blockingFirst();
            Observable observable = Observable.just((Object)((MerkleNode)merkleNodes.get((int)0)).hash.toBase58());
            return observable;
        }
        catch (Exception e) {
            return Observable.error((Throwable)new IpfsClientFailureException(String.format("Failed to add resource", new Object[0]), e));
        }
    }

    @Override
    public Observable<String> addPath(File path) {
        ParameterValidationUtils.checkParameter(path != null, "path is required");
        ParameterValidationUtils.checkParameter(path.isDirectory(), "path should be directory/folder");
        return Observable.just((Object)path).observeOn(Schedulers.io()).map(pathInput -> this.ipfsConnection.getIpfs().add((NamedStreamable)new NamedStreamable.FileWrapper(pathInput))).onErrorResumeNext(ex -> Observable.error((Throwable)new IpfsClientFailureException(String.format("Failed to add path", new Object[0]), (Throwable)ex))).observeOn(Schedulers.computation()).map(merkleNodes -> ((MerkleNode)merkleNodes.get((int)(merkleNodes.size() - 1))).hash.toBase58());
    }

    public Observable<List<String>> pin(String dataHash) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        return Observable.just((Object)dataHash).observeOn(Schedulers.computation()).map(hash -> Multihash.fromBase58((String)dataHash)).observeOn(Schedulers.io()).map(hash -> this.ipfsConnection.getIpfs().pin.add(hash)).onErrorResumeNext(ex -> Observable.error((Throwable)new IpfsClientFailureException(String.format("Failed to pin for %s", dataHash), (Throwable)ex))).observeOn(Schedulers.computation()).map(list -> list.stream().map(Multihash::toBase58).collect(Collectors.toList()));
    }

    @Override
    public Observable<InputStream> getByteStream(String dataHash) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        return Observable.just((Object)dataHash).observeOn(Schedulers.computation()).map(hash -> Multihash.fromBase58((String)dataHash)).observeOn(Schedulers.io()).map(hash -> this.ipfsConnection.getIpfs().catStream(hash)).onErrorResumeNext(ex -> Observable.error((Throwable)new IpfsClientFailureException(String.format("Failed to getByteStream resource for %s", dataHash), (Throwable)ex)));
    }
}

