/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.connection.FileStorageConnection;
import io.proximax.exceptions.DownloadForDataTypeNotSupportedException;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.service.FileDownloadService;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.InputStream;

public class RetrieveProximaxDataService {
    private final FileDownloadService fileDownloadService;

    public RetrieveProximaxDataService(FileStorageConnection fileStorageConnection) {
        this.fileDownloadService = new FileDownloadService(fileStorageConnection);
    }

    RetrieveProximaxDataService(FileDownloadService fileDownloadService) {
        this.fileDownloadService = fileDownloadService;
    }

    public Observable<InputStream> getDataByteStream(String dataHash, PrivacyStrategy privacyStrategy, boolean validateDigest, String digest, String contentType) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        ParameterValidationUtils.checkParameter(privacyStrategy != null, "privacyStrategy is required");
        if (contentType != null && contentType.equals("ipfs/directory")) {
            throw new DownloadForDataTypeNotSupportedException("download of path is not yet supported");
        }
        String digestToUse = validateDigest ? digest : null;
        return this.fileDownloadService.getByteStream(dataHash, privacyStrategy, digestToUse);
    }
}

