/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.privacy.strategy.PlainPrivacyStrategy;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.service.FileUploadResponse;
import io.proximax.service.repository.FileRepository;
import io.proximax.utils.DigestUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;

public class FileUploadService {
    private final FileRepository fileRepository;

    public FileUploadService(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public Observable<FileUploadResponse> uploadByteStream(Supplier<InputStream> byteStreamSupplier, PrivacyStrategy privacyStrategy, Boolean computeDigest) {
        ParameterValidationUtils.checkParameter(byteStreamSupplier != null, "byteStreamSupplier is required");
        boolean computeDigestToUse = Optional.ofNullable(computeDigest).orElse(false);
        PrivacyStrategy privacyStrategyToUse = privacyStrategy == null ? PlainPrivacyStrategy.create() : privacyStrategy;
        Optional<String> digestOpt = this.computeDigest(byteStreamSupplier, privacyStrategyToUse, computeDigestToUse);
        Observable<String> dataHashObservable = this.fileRepository.addByteStream(privacyStrategyToUse.encryptStream(byteStreamSupplier.get()));
        return dataHashObservable.map(dataHash -> new FileUploadResponse((String)dataHash, System.currentTimeMillis(), digestOpt.orElse(null)));
    }

    public Observable<FileUploadResponse> uploadPath(File path) {
        ParameterValidationUtils.checkParameter(path != null, "path is required");
        return this.fileRepository.addPath(path).map(dataHash -> new FileUploadResponse((String)dataHash, System.currentTimeMillis(), null));
    }

    private Optional<String> computeDigest(Supplier<InputStream> byteStreamSupplier, PrivacyStrategy privacyStrategy, boolean computeDigest) {
        return computeDigest ? Optional.of(DigestUtils.digest(privacyStrategy.encryptStream(byteStreamSupplier.get()))) : Optional.empty();
    }
}

