/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.connection.FileStorageConnection;
import io.proximax.privacy.strategy.PlainPrivacyStrategy;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.service.factory.FileRepositoryFactory;
import io.proximax.service.repository.FileRepository;
import io.proximax.utils.DigestUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class FileDownloadService {
    private final FileRepository fileRepository;

    public FileDownloadService(FileStorageConnection fileStorageConnection) {
        this.fileRepository = FileRepositoryFactory.create(fileStorageConnection);
    }

    FileDownloadService(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public Observable<InputStream> getByteStream(String dataHash, PrivacyStrategy privacyStrategy, String digest) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        PrivacyStrategy privacyStrategyToUse = privacyStrategy == null ? PlainPrivacyStrategy.create() : privacyStrategy;
        this.validateDigest(digest, dataHash);
        return this.fileRepository.getByteStream(dataHash).map(privacyStrategyToUse::decryptStream);
    }

    private void validateDigest(String digest, String dataHash) {
        if (StringUtils.isNotEmpty((CharSequence)digest)) {
            this.fileRepository.getByteStream(dataHash).map(undecryptedStream -> DigestUtils.validateDigest(undecryptedStream, digest)).blockingFirst();
        }
    }
}

