/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.connection.FileStorageConnection;
import io.proximax.exceptions.UploadParameterDataNotSupportedException;
import io.proximax.model.ProximaxDataModel;
import io.proximax.service.FileUploadResponse;
import io.proximax.service.FileUploadService;
import io.proximax.service.factory.FileRepositoryFactory;
import io.proximax.upload.AbstractByteStreamParameterData;
import io.proximax.upload.PathParameterData;
import io.proximax.upload.UploadParameter;
import io.proximax.utils.ContentTypeUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.util.Optional;

public class CreateProximaxDataService {
    private final FileUploadService fileUploadService;
    private final ContentTypeUtils contentTypeUtils;

    public CreateProximaxDataService(FileStorageConnection fileStorageConnection) {
        this.fileUploadService = new FileUploadService(FileRepositoryFactory.create(fileStorageConnection));
        this.contentTypeUtils = new ContentTypeUtils();
    }

    CreateProximaxDataService(FileUploadService fileUploadService, ContentTypeUtils contentTypeUtils) {
        this.fileUploadService = fileUploadService;
        this.contentTypeUtils = contentTypeUtils;
    }

    public Observable<ProximaxDataModel> createData(UploadParameter uploadParam) {
        ParameterValidationUtils.checkParameter(uploadParam != null, "uploadParam is required");
        if (uploadParam.getData() instanceof AbstractByteStreamParameterData) {
            return this.uploadByteStream(uploadParam, (AbstractByteStreamParameterData)uploadParam.getData());
        }
        if (uploadParam.getData() instanceof PathParameterData) {
            return this.uploadPath((PathParameterData)uploadParam.getData());
        }
        throw new UploadParameterDataNotSupportedException(String.format("Uploading of %s is not supported", uploadParam.getData().getClass().getName()));
    }

    private Observable<ProximaxDataModel> uploadByteStream(UploadParameter uploadParam, AbstractByteStreamParameterData byteStreamParamData) {
        Observable<Optional<String>> detectedContentTypeOb = this.detectContentType(uploadParam, byteStreamParamData);
        Observable<FileUploadResponse> fileUploadResponseOb = this.fileUploadService.uploadByteStream(byteStreamParamData::getByteStream, uploadParam.getPrivacyStrategy(), uploadParam.getComputeDigest());
        return Observable.zip(fileUploadResponseOb, detectedContentTypeOb, (ipfsUploadResponse, contentTypeOpt) -> ProximaxDataModel.create(byteStreamParamData, ipfsUploadResponse.getDataHash(), ipfsUploadResponse.getDigest(), contentTypeOpt.orElse(null), ipfsUploadResponse.getTimestamp()));
    }

    private Observable<Optional<String>> detectContentType(UploadParameter uploadParam, AbstractByteStreamParameterData byteStreamParamData) {
        return uploadParam.getDetectContentType() && byteStreamParamData.getContentType() == null ? this.contentTypeUtils.detectContentType(byteStreamParamData.getByteStream()).map(Optional::of) : Observable.just(Optional.ofNullable(byteStreamParamData.getContentType()));
    }

    private Observable<ProximaxDataModel> uploadPath(PathParameterData pathParamData) {
        return this.fileUploadService.uploadPath(pathParamData.getPath()).map(ipfsUploadResponse -> ProximaxDataModel.create(pathParamData, ipfsUploadResponse.getDataHash(), null, pathParamData.getContentType(), ipfsUploadResponse.getTimestamp()));
    }
}

