/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.connection.BlockchainNetworkConnection;
import io.proximax.exceptions.GetTransactionFailureException;
import io.proximax.exceptions.TransactionNotAllowedException;
import io.proximax.model.ProximaxMessagePayloadModel;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.blockchain.NetworkType;
import io.proximax.sdk.model.mosaic.Mosaic;
import io.proximax.sdk.model.mosaic.MosaicId;
import io.proximax.sdk.model.transaction.Deadline;
import io.proximax.sdk.model.transaction.Message;
import io.proximax.sdk.model.transaction.SignedTransaction;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.sdk.model.transaction.TransactionDeadline;
import io.proximax.sdk.model.transaction.TransactionType;
import io.proximax.sdk.model.transaction.TransferTransaction;
import io.proximax.sdk.model.transaction.UInt64Id;
import io.proximax.service.BlockchainMessageService;
import io.proximax.service.client.catapult.TransactionClient;
import io.proximax.utils.NemUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;

public class BlockchainTransactionService {
    private final BlockchainNetworkConnection blockchainNetworkConnection;
    private final BlockchainMessageService blockchainMessageService;
    private final TransactionClient transactionClient;
    private final NemUtils nemUtils;

    public BlockchainTransactionService(BlockchainNetworkConnection blockchainNetworkConnection) throws MalformedURLException {
        this.blockchainNetworkConnection = blockchainNetworkConnection;
        this.transactionClient = new TransactionClient(blockchainNetworkConnection);
        this.nemUtils = new NemUtils(blockchainNetworkConnection.getNetworkType());
        this.blockchainMessageService = new BlockchainMessageService(blockchainNetworkConnection);
    }

    BlockchainTransactionService(BlockchainNetworkConnection blockchainNetworkConnection, TransactionClient transactionClient, NemUtils nemUtils, BlockchainMessageService blockchainMessageService) {
        this.blockchainNetworkConnection = blockchainNetworkConnection;
        this.transactionClient = transactionClient;
        this.nemUtils = nemUtils;
        this.blockchainMessageService = blockchainMessageService;
    }

    public Observable<TransferTransaction> getTransferTransaction(String transactionHash) {
        ParameterValidationUtils.checkParameter(transactionHash != null, "transactionHash is required");
        return this.transactionClient.getTransaction(transactionHash).onErrorResumeNext(ex -> Observable.error((Throwable)new GetTransactionFailureException(String.format("Unable to find transfer transaction for %s", transactionHash), (Throwable)ex))).map(transaction -> {
            if (!transaction.getType().equals((Object)TransactionType.TRANSFER) || !(transaction instanceof TransferTransaction)) {
                throw new TransactionNotAllowedException("Expecting a transfer transaction");
            }
            return (TransferTransaction)transaction;
        });
    }

    public Observable<String> createAndAnnounceTransaction(ProximaxMessagePayloadModel messagePayload, String signerPrivateKey, String recipientPublicKey, String recipientAddress, int transactionDeadline, List<Mosaic> transactionMosaics, boolean useBlockchainSecureMessage) {
        ParameterValidationUtils.checkParameter(signerPrivateKey != null, "signerPrivateKey is required");
        ParameterValidationUtils.checkParameter(messagePayload != null, "messagePayload is required");
        Message message = this.blockchainMessageService.createMessage(messagePayload, signerPrivateKey, recipientPublicKey, recipientAddress, useBlockchainSecureMessage);
        Address recipient = this.getRecipient(signerPrivateKey, recipientPublicKey, recipientAddress);
        TransferTransaction transaction = this.createTransaction(recipient, transactionDeadline, transactionMosaics, message);
        SignedTransaction signedTransaction = this.nemUtils.signTransaction(signerPrivateKey, (Transaction)transaction);
        this.transactionClient.announce(signedTransaction, this.nemUtils.getAddressFromPrivateKey(signerPrivateKey));
        return Observable.just((Object)signedTransaction.getHash());
    }

    private Address getRecipient(String signerPrivateKey, String recipientPublicKey, String recipientAddress) {
        if (recipientPublicKey != null) {
            return this.nemUtils.getAddressFromPublicKey(recipientPublicKey);
        }
        if (recipientAddress != null) {
            return this.nemUtils.getAddress(recipientAddress);
        }
        return this.nemUtils.getAddressFromPrivateKey(signerPrivateKey);
    }

    private TransferTransaction createTransaction(Address recipientAddress, int transactionDeadline, List<Mosaic> transactionMosaicsParam, Message message) {
        List<Mosaic> mosaics = transactionMosaicsParam == null ? Collections.singletonList(new Mosaic((UInt64Id)new MosaicId(new BigInteger("0DC67FBE1CAD29E3", 16)), BigInteger.valueOf(1L))) : transactionMosaicsParam;
        return TransferTransaction.create((TransactionDeadline)Deadline.create((int)transactionDeadline, (ChronoUnit)ChronoUnit.HOURS), (Address)recipientAddress, mosaics, (Message)message, (NetworkType)this.blockchainNetworkConnection.getNetworkType());
    }
}

