/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.service;

import io.proximax.connection.BlockchainNetworkConnection;
import io.proximax.core.crypto.KeyPair;
import io.proximax.core.crypto.PrivateKey;
import io.proximax.core.crypto.PublicKey;
import io.proximax.exceptions.DownloadForMessageTypeNotSupportedException;
import io.proximax.exceptions.InvalidPrivateKeyOnDownloadException;
import io.proximax.exceptions.MissingPrivateKeyOnDownloadException;
import io.proximax.exceptions.MissingSignerOnTransferTransactionException;
import io.proximax.model.ProximaxMessagePayloadModel;
import io.proximax.sdk.model.account.Address;
import io.proximax.sdk.model.account.PublicAccount;
import io.proximax.sdk.model.blockchain.NetworkType;
import io.proximax.sdk.model.transaction.Message;
import io.proximax.sdk.model.transaction.PlainMessage;
import io.proximax.sdk.model.transaction.SecureMessage;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.sdk.model.transaction.TransferTransaction;
import io.proximax.service.client.catapult.AccountClient;
import io.proximax.utils.JsonUtils;
import io.proximax.utils.ParameterValidationUtils;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Optional;

public class BlockchainMessageService {
    private final NetworkType networkType;
    private final AccountClient accountClient;

    public BlockchainMessageService(BlockchainNetworkConnection blockchainNetworkConnection) throws MalformedURLException {
        this.accountClient = new AccountClient(blockchainNetworkConnection);
        this.networkType = blockchainNetworkConnection.getNetworkType();
    }

    BlockchainMessageService(NetworkType networkType, AccountClient accountClient) {
        this.networkType = networkType;
        this.accountClient = accountClient;
    }

    public Message createMessage(ProximaxMessagePayloadModel messagePayload, String senderPrivateKey, String recipientPublicKeyRaw, String recipientAddress, boolean useBlockchainSecureMessage) {
        ParameterValidationUtils.checkParameter(messagePayload != null, "messagePayload is required");
        String payload = JsonUtils.toJson(messagePayload);
        if (useBlockchainSecureMessage) {
            PublicKey recipientPublicKey = this.getRecipientPublicKey(senderPrivateKey, recipientPublicKeyRaw, recipientAddress);
            PrivateKey signerPrivateKey = PrivateKey.fromHexString((String)senderPrivateKey);
            return SecureMessage.create((PrivateKey)signerPrivateKey, (PublicKey)recipientPublicKey, (String)payload);
        }
        return PlainMessage.create((String)payload);
    }

    public String getMessagePayload(TransferTransaction transferTransaction, String accountPrivateKey) {
        ParameterValidationUtils.checkParameter(transferTransaction != null, "transferTransaction is required");
        if (transferTransaction.getMessage() instanceof PlainMessage) {
            return new String(transferTransaction.getMessage().getEncodedPayload(), Charset.forName("UTF-8"));
        }
        if (transferTransaction.getMessage() instanceof SecureMessage) {
            if (accountPrivateKey == null) {
                throw new MissingPrivateKeyOnDownloadException("accountPrivateKey is required to download a secure message");
            }
            KeyPair retrieverKeyPair = new KeyPair(PrivateKey.fromHexString((String)accountPrivateKey));
            String messagePayload = ((SecureMessage)transferTransaction.getMessage()).decrypt(retrieverKeyPair, new KeyPair(this.getTransactionOtherPartyPublicKey(retrieverKeyPair, transferTransaction)));
            return messagePayload;
        }
        throw new DownloadForMessageTypeNotSupportedException(String.format("Download of message type %s is not supported", transferTransaction.getMessage().getClass().getSimpleName()));
    }

    private PublicKey getRecipientPublicKey(String senderPrivateKey, String recipientPublicKey, String recipientAddress) {
        if (recipientPublicKey != null) {
            return PublicKey.fromHexString((String)recipientPublicKey);
        }
        if (recipientAddress != null) {
            PublicKey senderPublicKey = new KeyPair(PrivateKey.fromHexString((String)senderPrivateKey)).getPublicKey();
            if (this.isSenderPrivateKeySameWithRecipientAddress(senderPublicKey, recipientAddress)) {
                return senderPublicKey;
            }
            return this.accountClient.getPublicKey(recipientAddress);
        }
        return new KeyPair(PrivateKey.fromHexString((String)senderPrivateKey)).getPublicKey();
    }

    private boolean isSenderPrivateKeySameWithRecipientAddress(PublicKey signerPublicKey, String recipientAddress) {
        Address senderAddress = Address.createFromPublicKey((String)signerPublicKey.toString(), (NetworkType)this.networkType);
        return senderAddress.plain().equals(recipientAddress);
    }

    private PublicKey getTransactionOtherPartyPublicKey(KeyPair retrieverKeyPair, TransferTransaction transferTransaction) {
        PublicAccount senderAccount = (PublicAccount)Optional.of(transferTransaction).flatMap(Transaction::getSigner).orElseThrow(() -> new MissingSignerOnTransferTransactionException("Unexpected missing signer on transfer transaction"));
        Address recipient = (Address)transferTransaction.getRecipient().getAddress().orElseThrow(() -> new RuntimeException("Unexpected missing recipient address of transfer transaction"));
        Address retrieverAddress = Address.createFromPublicKey((String)retrieverKeyPair.getPublicKey().toString(), (NetworkType)this.networkType);
        if (retrieverAddress.equals((Object)recipient)) {
            return PublicKey.fromHexString((String)senderAccount.getPublicKey());
        }
        if (retrieverAddress.equals((Object)senderAccount.getAddress())) {
            return this.accountClient.getPublicKey(recipient.plain());
        }
        throw new InvalidPrivateKeyOnDownloadException("accountPrivateKey cannot be used to read secure transaction message");
    }
}

