/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.search;

import io.proximax.async.AsyncCallbacks;
import io.proximax.async.AsyncTask;
import io.proximax.connection.ConnectionConfig;
import io.proximax.exceptions.SearchFailureException;
import io.proximax.model.ProximaxMessagePayloadModel;
import io.proximax.sdk.model.account.Account;
import io.proximax.sdk.model.account.PublicAccount;
import io.proximax.sdk.model.blockchain.NetworkType;
import io.proximax.sdk.model.transaction.Transaction;
import io.proximax.sdk.model.transaction.TransactionInfo;
import io.proximax.sdk.model.transaction.TransferTransaction;
import io.proximax.search.SearchParameter;
import io.proximax.search.SearchResult;
import io.proximax.search.SearchResultItem;
import io.proximax.service.RetrieveProximaxMessagePayloadService;
import io.proximax.service.client.catapult.AccountClient;
import io.proximax.utils.AsyncUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Searcher {
    private static final int BATCH_TRANSACTION_SIZE = 100;
    private final NetworkType networkType;
    private final AccountClient accountClient;
    private final RetrieveProximaxMessagePayloadService retrieveProximaxMessagePayloadService;

    public Searcher(ConnectionConfig connectionConfig) {
        this.networkType = connectionConfig.getBlockchainNetworkConnection().getNetworkType();
        try {
            this.accountClient = new AccountClient(connectionConfig.getBlockchainNetworkConnection());
            this.retrieveProximaxMessagePayloadService = new RetrieveProximaxMessagePayloadService(connectionConfig.getBlockchainNetworkConnection());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to initialize", e);
        }
    }

    Searcher(AccountClient accountClient, RetrieveProximaxMessagePayloadService retrieveProximaxMessagePayloadService, NetworkType networkType) {
        this.networkType = networkType;
        this.accountClient = accountClient;
        this.retrieveProximaxMessagePayloadService = retrieveProximaxMessagePayloadService;
    }

    public SearchResult search(SearchParameter param) {
        ParameterValidationUtils.checkParameter(param != null, "param is required");
        return (SearchResult)this.doSearch(param).blockingFirst();
    }

    public AsyncTask searchAsync(SearchParameter param, AsyncCallbacks<SearchResult> asyncCallbacks) {
        ParameterValidationUtils.checkParameter(param != null, "param is required");
        AsyncTask asyncTask = new AsyncTask();
        AsyncUtils.processFirstItem(this.doSearch(param), asyncCallbacks, asyncTask);
        return asyncTask;
    }

    private Observable<SearchResult> doSearch(SearchParameter param) {
        return Observable.fromCallable(() -> {
            try {
                String fromTransactionId = param.getFromTransactionId();
                ArrayList<SearchResultItem> results = new ArrayList<SearchResultItem>();
                PublicAccount publicAccount = this.getPublicAccount(param.getAccountPrivateKey(), param.getAccountPublicKey(), param.getAccountAddress());
                while (results.size() < param.getResultSize()) {
                    List transactions = (List)this.accountClient.getTransactions(param.getTransactionFilter(), 100, publicAccount, fromTransactionId).blockingFirst();
                    List resultSet = transactions.parallelStream().map(txn -> this.convertToResultItemIfMatchingCriteria((Transaction)txn, param)).filter(Optional::isPresent).map(Optional::get).limit(param.getResultSize() - results.size()).collect(Collectors.toList());
                    results.addAll(resultSet);
                    if (transactions.size() != 100) break;
                    fromTransactionId = ((Transaction)transactions.get(transactions.size() - 1)).getTransactionInfo().flatMap(TransactionInfo::getId).orElse(null);
                }
                String toTransactionId = results.isEmpty() ? null : ((SearchResultItem)results.get(results.size() - 1)).getTransactionId();
                return new SearchResult(results, param.getFromTransactionId(), toTransactionId);
            }
            catch (RuntimeException ex) {
                throw new SearchFailureException("Search failed.", ex);
            }
        });
    }

    private PublicAccount getPublicAccount(String accountPrivateKey, String accountPublicKey, String accountAddress) {
        if (accountPrivateKey != null) {
            return Account.createFromPrivateKey((String)accountPrivateKey, (NetworkType)this.networkType).getPublicAccount();
        }
        if (accountPublicKey != null) {
            return PublicAccount.createFromPublicKey((String)accountPublicKey, (NetworkType)this.networkType);
        }
        if (accountAddress != null) {
            return PublicAccount.createFromPublicKey((String)this.accountClient.getPublicKey(accountAddress).toString(), (NetworkType)this.networkType);
        }
        throw new IllegalArgumentException("accountPrivateKey, accountPublicKey or accountAddress must be provided");
    }

    private Optional<SearchResultItem> convertToResultItemIfMatchingCriteria(Transaction transaction, SearchParameter param) {
        if (transaction instanceof TransferTransaction) {
            try {
                ProximaxMessagePayloadModel messagePayload = this.retrieveProximaxMessagePayloadService.getMessagePayload((TransferTransaction)transaction, param.getAccountPrivateKey());
                if (messagePayload != null && messagePayload.getVersion() != null && messagePayload.getPrivacyType() != 0 && messagePayload.getData() != null && messagePayload.getData().getTimestamp() != null && messagePayload.getData().getDataHash() != null && this.matchesSearchCriteria(messagePayload, param.getNameFilter(), param.getDescriptionFilter(), param.getMetadataKeyFilter(), param.getMetadataValueFilter())) {
                    return Optional.of(new SearchResultItem(transaction.getTransactionInfo().flatMap(TransactionInfo::getHash).orElse(null), transaction.getTransactionInfo().flatMap(TransactionInfo::getId).orElse(null), messagePayload));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private boolean matchesSearchCriteria(ProximaxMessagePayloadModel messagePayload, String nameFilter, String descriptionFilter, String metadataKeyFilter, String metadataValueFilter) {
        if (!(nameFilter == null || messagePayload.getData().getName() != null && messagePayload.getData().getName().contains(nameFilter))) {
            return false;
        }
        if (!(descriptionFilter == null || messagePayload.getData().getDescription() != null && messagePayload.getData().getDescription().contains(descriptionFilter))) {
            return false;
        }
        return metadataKeyFilter == null || !(metadataValueFilter != null ? messagePayload.getData().getMetadata() == null || !metadataValueFilter.equals(messagePayload.getData().getMetadata().get(metadataKeyFilter)) : messagePayload.getData().getMetadata() == null || !messagePayload.getData().getMetadata().containsKey(metadataKeyFilter));
    }
}

