/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.privacy.strategy;

import com.codahale.shamir.Scheme;
import io.proximax.cipher.PBECipherEncryptor;
import io.proximax.model.PrivacyType;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.utils.ParameterValidationUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ShamirSecretSharingPrivacyStrategy
extends PrivacyStrategy {
    private final char[] secret;
    private final PBECipherEncryptor pbeCipherEncryptor;

    ShamirSecretSharingPrivacyStrategy(PBECipherEncryptor pbeCipherEncryptor, int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
        ParameterValidationUtils.checkParameter(secretTotalPartCount > 0, "secretTotalPartCount should be a positive number");
        ParameterValidationUtils.checkParameter(secretMinimumPartCountToBuild > 0 && secretMinimumPartCountToBuild <= secretTotalPartCount, "secretMinimumPartCountToBuild should be a positive number less than or equal to secretTotalPartCount");
        ParameterValidationUtils.checkParameter(secretParts != null, "secretParts is required");
        ParameterValidationUtils.checkParameter(secretParts.size() >= secretMinimumPartCountToBuild, "secretParts should meet minimum part count as defined by secretMinimumPartCountToBuild");
        this.secret = new String(Scheme.of((int)secretTotalPartCount, (int)secretMinimumPartCountToBuild).join(secretParts)).toCharArray();
        this.pbeCipherEncryptor = pbeCipherEncryptor;
    }

    @Override
    public int getPrivacyType() {
        return PrivacyType.SHAMIR.getValue();
    }

    @Override
    public final InputStream encryptStream(InputStream stream) {
        return this.pbeCipherEncryptor.encryptStream(stream, this.secret);
    }

    @Override
    public final InputStream decryptStream(InputStream encryptedStream) {
        return this.pbeCipherEncryptor.decryptStream(encryptedStream, this.secret);
    }

    public static ShamirSecretSharingPrivacyStrategy create(int secretTotalPartCount, int secretMinimumPartCountToBuild, SecretPart ... secretParts) {
        return new ShamirSecretSharingPrivacyStrategy(new PBECipherEncryptor(), secretTotalPartCount, secretMinimumPartCountToBuild, Stream.of(secretParts).collect(Collectors.toMap(parts -> ((SecretPart)parts).index, parts -> ((SecretPart)parts).secretPart)));
    }

    public static ShamirSecretSharingPrivacyStrategy create(int secretTotalPartCount, int secretMinimumPartCountToBuild, List<SecretPart> secretParts) {
        return new ShamirSecretSharingPrivacyStrategy(new PBECipherEncryptor(), secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts.stream().collect(Collectors.toMap(parts -> ((SecretPart)parts).index, parts -> ((SecretPart)parts).secretPart)));
    }

    public static ShamirSecretSharingPrivacyStrategy create(int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
        return new ShamirSecretSharingPrivacyStrategy(new PBECipherEncryptor(), secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts);
    }

    public static class SecretPart {
        private final int index;
        private final byte[] secretPart;

        public SecretPart(int index, byte[] secretPart) {
            this.index = index;
            this.secretPart = secretPart;
        }

        public static SecretPart secretPart(int index, byte[] secretPart) {
            return new SecretPart(index, secretPart);
        }
    }
}

