/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.privacy.strategy;

import io.proximax.cipher.PBECipherEncryptor;
import io.proximax.model.PrivacyType;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.utils.ParameterValidationUtils;
import io.proximax.utils.PasswordUtils;
import java.io.InputStream;

public final class PasswordPrivacyStrategy
extends PrivacyStrategy {
    public static final int MINIMUM_PASSWORD_LENGTH = 10;
    private final PBECipherEncryptor pbeCipherEncryptor;
    private final char[] passwordCharArray;
    private final String password;

    PasswordPrivacyStrategy(PBECipherEncryptor pbeCipherEncryptor, String password) {
        ParameterValidationUtils.checkParameter(password != null, "password is required");
        ParameterValidationUtils.checkParameter(password.length() >= 10, String.format("minimum length for password is %d", 10));
        this.pbeCipherEncryptor = pbeCipherEncryptor;
        this.password = password;
        this.passwordCharArray = password.toCharArray();
    }

    @Override
    public int getPrivacyType() {
        return PrivacyType.PASSWORD.getValue();
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public final InputStream encryptStream(InputStream stream) {
        return this.pbeCipherEncryptor.encryptStream(stream, this.passwordCharArray);
    }

    @Override
    public final InputStream decryptStream(InputStream encryptedStream) {
        return this.pbeCipherEncryptor.decryptStream(encryptedStream, this.passwordCharArray);
    }

    public static PasswordPrivacyStrategy create(String password) {
        return new PasswordPrivacyStrategy(new PBECipherEncryptor(), password);
    }

    public static PasswordPrivacyStrategy create() {
        return new PasswordPrivacyStrategy(new PBECipherEncryptor(), PasswordUtils.generatePassword());
    }
}

