/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.privacy.strategy;

import io.proximax.cipher.BlockchainKeysCipherEncryptor;
import io.proximax.core.crypto.KeyPair;
import io.proximax.core.crypto.PrivateKey;
import io.proximax.core.crypto.PublicKey;
import io.proximax.model.PrivacyType;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.utils.ParameterValidationUtils;
import java.io.InputStream;

public final class NemKeysPrivacyStrategy
extends PrivacyStrategy {
    private final BlockchainKeysCipherEncryptor blockchainKeysCipherEncryptor;
    private final KeyPair keyPairOfPrivateKey;
    private final KeyPair keyPairOfPublicKey;

    NemKeysPrivacyStrategy(BlockchainKeysCipherEncryptor blockchainKeysCipherEncryptor, String privateKey, String publicKey) {
        ParameterValidationUtils.checkParameter(privateKey != null, "private key is required");
        ParameterValidationUtils.checkParameter(publicKey != null, "public key is required");
        this.blockchainKeysCipherEncryptor = blockchainKeysCipherEncryptor;
        this.keyPairOfPrivateKey = new KeyPair(PrivateKey.fromHexString((String)privateKey));
        this.keyPairOfPublicKey = new KeyPair(PublicKey.fromHexString((String)publicKey));
    }

    @Override
    public int getPrivacyType() {
        return PrivacyType.NEMKEYS.getValue();
    }

    @Override
    public final InputStream encryptStream(InputStream stream) {
        return this.blockchainKeysCipherEncryptor.encryptStream(stream, this.keyPairOfPrivateKey, this.keyPairOfPublicKey);
    }

    @Override
    public final InputStream decryptStream(InputStream encryptedStream) {
        return this.blockchainKeysCipherEncryptor.decryptStream(encryptedStream, this.keyPairOfPrivateKey, this.keyPairOfPublicKey);
    }

    public static NemKeysPrivacyStrategy create(String privateKey, String publicKey) {
        return new NemKeysPrivacyStrategy(new BlockchainKeysCipherEncryptor(), privateKey, publicKey);
    }
}

