/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.download;

import io.proximax.async.AsyncCallbacks;
import io.proximax.async.AsyncTask;
import io.proximax.connection.ConnectionConfig;
import io.proximax.download.DirectDownloadParameter;
import io.proximax.download.DownloadParameter;
import io.proximax.download.DownloadResult;
import io.proximax.download.DownloadResultData;
import io.proximax.exceptions.DirectDownloadFailureException;
import io.proximax.exceptions.DownloadFailureException;
import io.proximax.exceptions.DownloadInitFailureException;
import io.proximax.model.ProximaxDataModel;
import io.proximax.model.ProximaxMessagePayloadModel;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.sdk.model.transaction.TransferTransaction;
import io.proximax.service.BlockchainTransactionService;
import io.proximax.service.RetrieveProximaxDataService;
import io.proximax.service.RetrieveProximaxMessagePayloadService;
import io.proximax.utils.AsyncUtils;
import io.proximax.utils.ParameterValidationUtils;
import io.reactivex.Observable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Optional;
import java.util.function.Supplier;

public class Downloader {
    private final BlockchainTransactionService blockchainTransactionService;
    private final RetrieveProximaxMessagePayloadService retrieveProximaxMessagePayloadService;
    private final RetrieveProximaxDataService retrieveProximaxDataService;

    public Downloader(ConnectionConfig connectionConfig) {
        this.retrieveProximaxDataService = new RetrieveProximaxDataService(connectionConfig.getFileStorageConnection());
        try {
            this.retrieveProximaxMessagePayloadService = new RetrieveProximaxMessagePayloadService(connectionConfig.getBlockchainNetworkConnection());
            this.blockchainTransactionService = new BlockchainTransactionService(connectionConfig.getBlockchainNetworkConnection());
        }
        catch (MalformedURLException e) {
            throw new DownloadInitFailureException("Failed to initialize", e);
        }
    }

    Downloader(BlockchainTransactionService blockchainTransactionService, RetrieveProximaxMessagePayloadService retrieveProximaxMessagePayloadService, RetrieveProximaxDataService retrieveProximaxDataService) {
        this.blockchainTransactionService = blockchainTransactionService;
        this.retrieveProximaxMessagePayloadService = retrieveProximaxMessagePayloadService;
        this.retrieveProximaxDataService = retrieveProximaxDataService;
    }

    public DownloadResult download(DownloadParameter downloadParam) {
        ParameterValidationUtils.checkParameter(downloadParam != null, "downloadParam is required");
        return (DownloadResult)this.doCompleteDownload(downloadParam).blockingFirst();
    }

    public AsyncTask downloadAsync(DownloadParameter downloadParam, AsyncCallbacks<DownloadResult> asyncCallbacks) {
        ParameterValidationUtils.checkParameter(downloadParam != null, "downloadParam is required");
        AsyncTask asyncTask = new AsyncTask();
        AsyncUtils.processFirstItem(this.doCompleteDownload(downloadParam), asyncCallbacks, asyncTask);
        return asyncTask;
    }

    public InputStream directDownload(DirectDownloadParameter directDownloadParameter) {
        ParameterValidationUtils.checkParameter(directDownloadParameter != null, "directDownloadParameter is required");
        return (InputStream)this.doDirectDownload(directDownloadParameter).blockingFirst();
    }

    public AsyncTask directDownloadAsync(DirectDownloadParameter directDownloadParameter, AsyncCallbacks<InputStream> asyncCallbacks) {
        ParameterValidationUtils.checkParameter(directDownloadParameter != null, "directDownloadParameter is required");
        AsyncTask asyncTask = new AsyncTask();
        AsyncUtils.processFirstItem(this.doDirectDownload(directDownloadParameter), asyncCallbacks, asyncTask);
        return asyncTask;
    }

    private Observable<DownloadResult> doCompleteDownload(DownloadParameter downloadParam) {
        return Observable.fromCallable(() -> {
            try {
                DownloadResult downloadResult = (DownloadResult)this.blockchainTransactionService.getTransferTransaction(downloadParam.getTransactionHash()).map(transferTransaction -> this.retrieveProximaxMessagePayloadService.getMessagePayload((TransferTransaction)transferTransaction, downloadParam.getAccountPrivateKey())).map(messagePayload -> this.createCompleteDownloadResult((ProximaxMessagePayloadModel)messagePayload, () -> (InputStream)this.getDataByteStream(Optional.of(messagePayload), null, downloadParam.getPrivacyStrategy(), downloadParam.getValidateDigest(), null).blockingFirst(), downloadParam.getTransactionHash())).blockingFirst();
                return downloadResult;
            }
            catch (RuntimeException ex) {
                throw new DownloadFailureException("Download failed.", ex);
            }
        });
    }

    private DownloadResult createCompleteDownloadResult(ProximaxMessagePayloadModel messagePayload, Supplier<InputStream> byteStreamSupplier, String transactionHash) {
        ProximaxDataModel data = messagePayload.getData();
        return DownloadResult.create(transactionHash, messagePayload.getPrivacyType(), messagePayload.getVersion(), new DownloadResultData(byteStreamSupplier, data.getDigest(), data.getDataHash(), data.getTimestamp(), data.getDescription(), data.getName(), data.getContentType(), data.getMetadata()));
    }

    private Observable<InputStream> doDirectDownload(DirectDownloadParameter downloadParam) {
        return Observable.fromCallable(() -> {
            try {
                InputStream inputStream = (InputStream)this.getOptionalBlockchainTransaction(downloadParam.getTransactionHash()).map(transferTransactionOpt -> transferTransactionOpt.map(transferTransaction -> this.retrieveProximaxMessagePayloadService.getMessagePayload((TransferTransaction)transferTransaction, downloadParam.getAccountPrivateKey()))).flatMap(messagePayload -> this.getDataByteStream((Optional<ProximaxMessagePayloadModel>)messagePayload, downloadParam.getDataHash(), downloadParam.getPrivacyStrategy(), downloadParam.getValidateDigest(), downloadParam.getDigest())).blockingFirst();
                return inputStream;
            }
            catch (RuntimeException ex) {
                throw new DirectDownloadFailureException("Direct download failed.", ex);
            }
        });
    }

    private Observable<Optional<TransferTransaction>> getOptionalBlockchainTransaction(String transactionHash) {
        return Optional.ofNullable(transactionHash).map(hash -> this.blockchainTransactionService.getTransferTransaction((String)hash).map(Optional::of)).orElse(Observable.just(Optional.empty()));
    }

    private Observable<InputStream> getDataByteStream(Optional<ProximaxMessagePayloadModel> messagePayload, String dataHash, PrivacyStrategy privacyStrategy, boolean validateDigest, String digest) {
        String resolvedDataHash = messagePayload.map(payload -> payload.getData().getDataHash()).orElse(dataHash);
        String resolvedDigest = messagePayload.map(payload -> payload.getData().getDigest()).orElse(digest);
        String resolvedContentType = messagePayload.map(payload -> payload.getData().getContentType()).orElse(null);
        return this.retrieveProximaxDataService.getDataByteStream(resolvedDataHash, privacyStrategy, validateDigest, resolvedDigest, resolvedContentType);
    }
}

