/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.download;

import io.proximax.model.DataInfoModel;
import io.proximax.utils.ParameterValidationUtils;
import io.proximax.utils.StreamUtils;
import io.proximax.utils.TimeoutUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DownloadResultData
extends DataInfoModel {
    private final Supplier<InputStream> byteStreamSupplier;
    private final String digest;
    private final String dataHash;
    private final long timestamp;

    DownloadResultData(Supplier<InputStream> byteStreamSupplier, String digest, String dataHash, long timestamp, String description, String name, String contentType, Map<String, String> metadata) {
        super(description, name, contentType, metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata));
        this.byteStreamSupplier = byteStreamSupplier;
        this.digest = digest;
        this.dataHash = dataHash;
        this.timestamp = timestamp;
    }

    public InputStream getByteStream() {
        return this.byteStreamSupplier.get();
    }

    public InputStream getByteStream(long timeout, TimeUnit timeUnit) {
        return TimeoutUtils.get(this.byteStreamSupplier, timeout, timeUnit);
    }

    public String getDigest() {
        return this.digest;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getContentAsString(String encoding) {
        return StreamUtils.toString(this.byteStreamSupplier.get(), encoding);
    }

    public String getContentAsString(String encoding, long timeout, TimeUnit timeUnit) {
        return StreamUtils.toString(this.getByteStream(timeout, timeUnit), encoding);
    }

    public byte[] getContentAsByteArray() {
        return StreamUtils.toByteArray(this.byteStreamSupplier.get());
    }

    public byte[] getContentAsByteArray(long timeout, TimeUnit timeUnit) {
        return StreamUtils.toByteArray(this.getByteStream(timeout, timeUnit));
    }

    public void saveToFile(File file) {
        ParameterValidationUtils.checkParameter(file != null, "file is required");
        StreamUtils.saveToFile(this.byteStreamSupplier.get(), file);
    }

    public void saveToFile(File file, long timeout, TimeUnit timeUnit) {
        ParameterValidationUtils.checkParameter(file != null, "file is required");
        StreamUtils.saveToFile(this.getByteStream(timeout, timeUnit), file);
    }
}

