/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.download;

import io.proximax.core.crypto.PrivateKey;
import io.proximax.download.DownloadParameter;
import io.proximax.privacy.strategy.NemKeysPrivacyStrategy;
import io.proximax.privacy.strategy.PasswordPrivacyStrategy;
import io.proximax.privacy.strategy.PlainPrivacyStrategy;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.utils.ParameterValidationUtils;

public class DownloadParameterBuilder {
    private final String transactionHash;
    private String accountPrivateKey;
    private PrivacyStrategy privacyStrategy;
    private Boolean validateDigest;

    public DownloadParameterBuilder(String transactionHash) {
        ParameterValidationUtils.checkParameter(transactionHash != null, "transactionHash is required");
        this.transactionHash = transactionHash;
    }

    public DownloadParameterBuilder withAccountPrivateKey(String accountPrivateKey) {
        ParameterValidationUtils.checkParameter(() -> accountPrivateKey == null || PrivateKey.fromHexString((String)accountPrivateKey) != null, "accountPrivateKey should be a valid private key");
        this.accountPrivateKey = accountPrivateKey;
        return this;
    }

    public DownloadParameterBuilder withValidateDigest(Boolean validateDigest) {
        this.validateDigest = validateDigest;
        return this;
    }

    public DownloadParameterBuilder withPrivacyStrategy(PrivacyStrategy privacyStrategy) {
        this.privacyStrategy = privacyStrategy;
        return this;
    }

    public DownloadParameterBuilder withPlainPrivacy() {
        this.privacyStrategy = PlainPrivacyStrategy.create();
        return this;
    }

    public DownloadParameterBuilder withNemKeysPrivacy(String privateKey, String publicKey) {
        this.privacyStrategy = NemKeysPrivacyStrategy.create(privateKey, publicKey);
        return this;
    }

    public DownloadParameterBuilder withPasswordPrivacy(String password) {
        this.privacyStrategy = PasswordPrivacyStrategy.create(password);
        return this;
    }

    public DownloadParameter build() {
        if (this.privacyStrategy == null) {
            this.privacyStrategy = PlainPrivacyStrategy.create();
        }
        if (this.validateDigest == null) {
            this.validateDigest = false;
        }
        return new DownloadParameter(this.transactionHash, this.accountPrivateKey, this.privacyStrategy, this.validateDigest);
    }
}

