/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.download;

import io.ipfs.multihash.Multihash;
import io.proximax.core.crypto.PrivateKey;
import io.proximax.download.DirectDownloadParameter;
import io.proximax.privacy.strategy.NemKeysPrivacyStrategy;
import io.proximax.privacy.strategy.PasswordPrivacyStrategy;
import io.proximax.privacy.strategy.PlainPrivacyStrategy;
import io.proximax.privacy.strategy.PrivacyStrategy;
import io.proximax.utils.ParameterValidationUtils;
import java.util.Optional;

public class DirectDownloadParameterBuilder {
    private String transactionHash;
    private String accountPrivateKey;
    private String dataHash;
    private Boolean validateDigest;
    private PrivacyStrategy privacyStrategy;
    private String digest;

    private DirectDownloadParameterBuilder() {
    }

    public static DirectDownloadParameterBuilder createFromTransactionHash(String transactionHash, String accountPrivateKey, Boolean validateDigest) {
        ParameterValidationUtils.checkParameter(transactionHash != null, "transactionHash is required");
        ParameterValidationUtils.checkParameter(() -> accountPrivateKey == null || PrivateKey.fromHexString((String)accountPrivateKey) != null, "accountPrivateKey should be a valid private key");
        DirectDownloadParameterBuilder builder = new DirectDownloadParameterBuilder();
        builder.transactionHash = transactionHash;
        builder.accountPrivateKey = accountPrivateKey;
        builder.validateDigest = Optional.ofNullable(validateDigest).orElse(false);
        return builder;
    }

    public static DirectDownloadParameterBuilder createFromDataHash(String dataHash, String digest) {
        ParameterValidationUtils.checkParameter(dataHash != null, "dataHash is required");
        ParameterValidationUtils.checkParameter(() -> Multihash.fromBase58((String)dataHash) != null, "dataHash should be a valid ipfs hash");
        DirectDownloadParameterBuilder builder = new DirectDownloadParameterBuilder();
        builder.dataHash = dataHash;
        builder.digest = digest;
        builder.validateDigest = true;
        return builder;
    }

    public DirectDownloadParameterBuilder withPrivacyStrategy(PrivacyStrategy privacyStrategy) {
        this.privacyStrategy = privacyStrategy;
        return this;
    }

    public DirectDownloadParameterBuilder withPlainPrivacy() {
        this.privacyStrategy = PlainPrivacyStrategy.create();
        return this;
    }

    public DirectDownloadParameterBuilder withNemKeysPrivacy(String privateKey, String publicKey) {
        this.privacyStrategy = NemKeysPrivacyStrategy.create(privateKey, publicKey);
        return this;
    }

    public DirectDownloadParameterBuilder withPasswordPrivacy(String password) {
        this.privacyStrategy = PasswordPrivacyStrategy.create(password);
        return this;
    }

    public DirectDownloadParameter build() {
        if (this.privacyStrategy == null) {
            this.privacyStrategy = PlainPrivacyStrategy.create();
        }
        return new DirectDownloadParameter(this.transactionHash, this.accountPrivateKey, this.dataHash, this.validateDigest, this.privacyStrategy, this.digest);
    }
}

