/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.download;

import io.proximax.download.DirectDownloadParameterBuilder;
import io.proximax.privacy.strategy.PrivacyStrategy;

public class DirectDownloadParameter {
    private final String transactionHash;
    private final String accountPrivateKey;
    private final String dataHash;
    private final boolean validateDigest;
    private final PrivacyStrategy privacyStrategy;
    private final String digest;

    DirectDownloadParameter(String transactionHash, String accountPrivateKey, String dataHash, boolean validateDigest, PrivacyStrategy privacyStrategy, String digest) {
        this.transactionHash = transactionHash;
        this.accountPrivateKey = accountPrivateKey;
        this.dataHash = dataHash;
        this.validateDigest = validateDigest;
        this.privacyStrategy = privacyStrategy;
        this.digest = digest;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public String getAccountPrivateKey() {
        return this.accountPrivateKey;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public boolean getValidateDigest() {
        return this.validateDigest;
    }

    public PrivacyStrategy getPrivacyStrategy() {
        return this.privacyStrategy;
    }

    public String getDigest() {
        return this.digest;
    }

    public static DirectDownloadParameterBuilder createFromTransactionHash(String transactionHash) {
        return DirectDownloadParameterBuilder.createFromTransactionHash(transactionHash, null, null);
    }

    public static DirectDownloadParameterBuilder createFromTransactionHash(String transactionHash, String accountPrivateKey) {
        return DirectDownloadParameterBuilder.createFromTransactionHash(transactionHash, accountPrivateKey, null);
    }

    public static DirectDownloadParameterBuilder createFromTransactionHash(String transactionHash, boolean validateDigest) {
        return DirectDownloadParameterBuilder.createFromTransactionHash(transactionHash, null, validateDigest);
    }

    public static DirectDownloadParameterBuilder createFromTransactionHash(String transactionHash, String accountPrivateKey, boolean validateDigest) {
        return DirectDownloadParameterBuilder.createFromTransactionHash(transactionHash, accountPrivateKey, validateDigest);
    }

    public static DirectDownloadParameterBuilder createFromDataHash(String dataHash) {
        return DirectDownloadParameterBuilder.createFromDataHash(dataHash, null);
    }

    public static DirectDownloadParameterBuilder createFromDataHash(String dataHash, String digest) {
        return DirectDownloadParameterBuilder.createFromDataHash(dataHash, digest);
    }
}

