/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.connection;

import io.proximax.connection.FileStorageConnection;
import io.proximax.connection.HttpProtocol;
import io.proximax.exceptions.ConnectionConfigNotValidException;
import io.proximax.utils.ParameterValidationUtils;
import org.apache.http.client.utils.URIBuilder;

public class StorageConnection
extends FileStorageConnection {
    private final String apiUrl;
    private final String apiHost;
    private final int apiPort;
    private final HttpProtocol apiProtocol;
    private final String bearerToken;
    private final String nemAddress;

    public StorageConnection(String apiHost, int apiPort, HttpProtocol apiProtocol, String bearerToken, String nemAddress) {
        try {
            ParameterValidationUtils.checkParameter(apiHost != null, "apiHost is required");
            ParameterValidationUtils.checkParameter(apiPort > 0, "apiPort must be non-negative int");
            ParameterValidationUtils.checkParameter(apiProtocol != null, "apiPort is required");
            ParameterValidationUtils.checkParameter(bearerToken != null, "bearerToken is required");
            ParameterValidationUtils.checkParameter(nemAddress != null, "nemAddress is required");
            this.apiHost = apiHost;
            this.apiPort = apiPort;
            this.apiProtocol = apiProtocol;
            this.bearerToken = bearerToken;
            this.nemAddress = nemAddress;
            this.apiUrl = new URIBuilder().setHost(apiHost).setPort(apiPort).setScheme(apiProtocol.getProtocol()).build().toString();
        }
        catch (Exception e) {
            throw new ConnectionConfigNotValidException("Invalid api config provided", e);
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public String getNemAddress() {
        return this.nemAddress;
    }

    public HttpProtocol getApiProtocol() {
        return this.apiProtocol;
    }
}

