/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.connection;

import io.ipfs.api.IPFS;
import io.proximax.connection.FileStorageConnection;
import io.proximax.exceptions.ConnectionConfigNotValidException;
import io.proximax.utils.ParameterValidationUtils;

public class IpfsConnection
extends FileStorageConnection {
    private final IPFS ipfs;
    private final String apiHost;
    private final int apiPort;

    public IpfsConnection(String apiHost, int apiPort) {
        try {
            ParameterValidationUtils.checkParameter(apiHost != null, "apiHost is required");
            ParameterValidationUtils.checkParameter(apiPort > 0, "apiPort must be non-negative int");
            this.apiHost = apiHost;
            this.apiPort = apiPort;
            this.ipfs = new IPFS(apiHost, apiPort);
        }
        catch (RuntimeException e) {
            throw new ConnectionConfigNotValidException("Invalid api config provided", e);
        }
    }

    public IPFS getIpfs() {
        return this.ipfs;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public int getApiPort() {
        return this.apiPort;
    }
}

