/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.connection;

import io.proximax.connection.BlockchainNetworkConnection;
import io.proximax.connection.FileStorageConnection;
import io.proximax.connection.IpfsConnection;
import io.proximax.connection.StorageConnection;
import io.proximax.service.client.StorageNodeClient;

public class ConnectionConfig {
    private final BlockchainNetworkConnection blockchainNetworkConnection;
    private final FileStorageConnection fileStorageConnection;

    private ConnectionConfig(BlockchainNetworkConnection blockchainNetworkConnection, IpfsConnection ipfsConnection) {
        this.blockchainNetworkConnection = blockchainNetworkConnection;
        this.fileStorageConnection = ipfsConnection;
    }

    private ConnectionConfig(BlockchainNetworkConnection blockchainNetworkConnection, StorageConnection storageConnection) {
        this.blockchainNetworkConnection = blockchainNetworkConnection;
        this.fileStorageConnection = storageConnection;
    }

    public BlockchainNetworkConnection getBlockchainNetworkConnection() {
        return this.blockchainNetworkConnection;
    }

    public FileStorageConnection getFileStorageConnection() {
        return this.fileStorageConnection;
    }

    public static ConnectionConfig createWithLocalIpfsConnection(BlockchainNetworkConnection blockchainNetworkConnection, IpfsConnection ipfsConnection) {
        return new ConnectionConfig(blockchainNetworkConnection, ipfsConnection);
    }

    public static ConnectionConfig createWithStorageConnection(StorageConnection storageConnection) {
        StorageNodeClient storageNodeClient = new StorageNodeClient(storageConnection);
        StorageNodeClient.NodeInfoResponseBlockchainNetwork blockchainNetwork = ((StorageNodeClient.NodeInfoResponse)storageNodeClient.getNodeInfo().blockingFirst()).getBlockchainNetwork();
        BlockchainNetworkConnection blockchainNetworkConnection = new BlockchainNetworkConnection(blockchainNetwork.getNetworkType(), blockchainNetwork.getHost(), blockchainNetwork.getPort(), blockchainNetwork.getProtocol());
        return new ConnectionConfig(blockchainNetworkConnection, storageConnection);
    }

    public static ConnectionConfig createWithStorageConnection(BlockchainNetworkConnection blockchainNetworkConnection, StorageConnection storageConnection) {
        return new ConnectionConfig(blockchainNetworkConnection, storageConnection);
    }
}

