/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.connection;

import io.proximax.connection.HttpProtocol;
import io.proximax.exceptions.ConnectionConfigNotValidException;
import io.proximax.model.BlockchainNetworkType;
import io.proximax.sdk.BlockchainApi;
import io.proximax.sdk.model.blockchain.NetworkType;
import io.proximax.utils.ParameterValidationUtils;
import java.net.URL;
import org.apache.http.client.utils.URIBuilder;

public class BlockchainNetworkConnection {
    private final NetworkType networkType;
    private final String restApiUrl;
    private final String apiHost;
    private final int apiPort;
    private final HttpProtocol apiProtocol;
    private final BlockchainApi blockchainApi;

    public BlockchainNetworkConnection(BlockchainNetworkType networkType, String apiHost, int apiPort, HttpProtocol apiProtocol) {
        try {
            ParameterValidationUtils.checkParameter(networkType != null, "networkType is required");
            ParameterValidationUtils.checkParameter(apiHost != null, "apiHost is required");
            ParameterValidationUtils.checkParameter(apiPort > 0, "apiPort must be non-negative int");
            ParameterValidationUtils.checkParameter(apiProtocol != null, "apiProtocol is required");
            this.networkType = networkType.networkType;
            this.apiHost = apiHost;
            this.apiPort = apiPort;
            this.apiProtocol = apiProtocol;
            this.restApiUrl = new URIBuilder().setHost(apiHost).setPort(apiPort).setScheme(apiProtocol.getProtocol()).build().toString();
            this.blockchainApi = new BlockchainApi(new URL(this.restApiUrl), this.networkType);
        }
        catch (Exception e) {
            throw new ConnectionConfigNotValidException("Invalid api config provided", e);
        }
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getApiUrl() {
        return this.restApiUrl;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public HttpProtocol getApiProtocol() {
        return this.apiProtocol;
    }

    public BlockchainApi getBlockchainApi() {
        return this.blockchainApi;
    }
}

