/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.cipher;

import io.proximax.exceptions.DecryptionFailureException;
import io.proximax.exceptions.EncryptionFailureException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

public class PBECipherEncryptor {
    private static final String CONST_ALGO_PBKDF2 = "PBKDF2WithHmacSHA256";

    public InputStream encryptStream(InputStream byteStream, char[] password) {
        try {
            byte[] salt = new byte[32];
            byte[] iv = new byte[16];
            SecureRandom rand = new SecureRandom();
            rand.nextBytes(salt);
            rand.nextBytes(iv);
            Cipher cipher = this.getCipherInstance();
            cipher.init(1, (Key)this.getPBESecretKey(password, salt), this.getIvParameterSpec(iv));
            return new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream(salt), new ByteArrayInputStream(iv), new CipherInputStream(byteStream, cipher))));
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Failed to encrypt stream", e);
        }
    }

    public InputStream decryptStream(InputStream byteStream, char[] password) {
        try {
            byte[] salt = new byte[32];
            byte[] iv = new byte[16];
            IOUtils.read((InputStream)byteStream, (byte[])salt);
            IOUtils.read((InputStream)byteStream, (byte[])iv);
            Cipher cipher = this.getCipherInstance();
            cipher.init(2, (Key)this.getPBESecretKey(password, salt), this.getIvParameterSpec(iv));
            return new CipherInputStream(byteStream, cipher);
        }
        catch (Exception e) {
            throw new DecryptionFailureException("Failed to decrypt stream", e);
        }
    }

    private SecretKey getPBESecretKey(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, salt, 65536, 256);
        SecretKey tmp = factory.generateSecret(keyspec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private Cipher getCipherInstance() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5PADDING");
    }

    private IvParameterSpec getIvParameterSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }
}

