/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.cipher;

import io.proximax.core.crypto.Hashes;
import io.proximax.core.crypto.KeyPair;
import io.proximax.core.crypto.PrivateKey;
import io.proximax.core.crypto.ed25519.Ed25519Utils;
import io.proximax.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.proximax.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import io.proximax.exceptions.DecryptionFailureException;
import io.proximax.exceptions.EncryptionFailureException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

public class BlockchainKeysCipherEncryptor {
    public InputStream encryptStream(InputStream byteStream, KeyPair privateKeyPair, KeyPair publicKeyPair) {
        try {
            byte[] salt = new byte[32];
            byte[] iv = new byte[16];
            SecureRandom rand = new SecureRandom();
            rand.nextBytes(salt);
            rand.nextBytes(iv);
            Cipher cipher = this.getCipherInstance();
            cipher.init(1, (Key)BlockchainKeysCipherEncryptor.getSharedKey(salt, privateKeyPair, publicKeyPair), this.getIvParameterSpec(iv));
            return new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream(salt), new ByteArrayInputStream(iv), new CipherInputStream(byteStream, cipher))));
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Failed to encrypt stream", e);
        }
    }

    public InputStream decryptStream(InputStream byteStream, KeyPair privateKeyPair, KeyPair publicKeyPair) {
        try {
            byte[] salt = new byte[32];
            byte[] iv = new byte[16];
            IOUtils.read((InputStream)byteStream, (byte[])salt);
            IOUtils.read((InputStream)byteStream, (byte[])iv);
            Cipher cipher = this.getCipherInstance();
            cipher.init(2, (Key)BlockchainKeysCipherEncryptor.getSharedKey(salt, privateKeyPair, publicKeyPair), this.getIvParameterSpec(iv));
            return new CipherInputStream(byteStream, cipher);
        }
        catch (Exception e) {
            throw new DecryptionFailureException("Failed to decrypt stream", e);
        }
    }

    private Cipher getCipherInstance() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5PADDING");
    }

    private IvParameterSpec getIvParameterSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }

    private static SecretKey getSharedKey(byte[] salt, KeyPair privateKeyPair, KeyPair publicKeyPair) {
        Ed25519GroupElement senderA = new Ed25519EncodedGroupElement(publicKeyPair.getPublicKey().getRaw()).decode();
        senderA.precomputeForScalarMultiplication();
        byte[] sharedKey = senderA.scalarMultiply(Ed25519Utils.prepareForScalarMultiply((PrivateKey)privateKeyPair.getPrivateKey())).encode().getRaw();
        for (int i = 0; i < 32; ++i) {
            int n = i;
            sharedKey[n] = (byte)(sharedKey[n] ^ salt[i]);
        }
        return new SecretKeySpec(Hashes.sha3_256((byte[][])new byte[][]{sharedKey}), "AES");
    }
}

