/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.async;

import java.util.function.Consumer;

public class AsyncCallbacks<T> {
    private final Consumer<T> successCallback;
    private final Consumer<Throwable> failureCallback;

    public AsyncCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
        this.successCallback = successCallback;
        this.failureCallback = failureCallback;
    }

    public static <T> AsyncCallbacks<T> create(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
        return new AsyncCallbacks<T>(successCallback, failureCallback);
    }

    public void onSuccess(T result) {
        if (this.successCallback != null) {
            this.successCallback.accept(result);
        }
    }

    public void onFailure(Throwable ex) {
        if (this.failureCallback != null) {
            this.failureCallback.accept(ex);
        }
    }
}

