/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins.config;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class Template {
    private final File templateDirectory;

    public Template(File templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public void fromTemplate(String templateName, Object context, File outputDirectory) throws IOException {
        this.fromTemplate(templateName, context, outputDirectory, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fromTemplate(String templateName, Object context, File outputDirectory, String outputName) throws IOException {
        File target = outputName != null ? new File(outputDirectory, outputName) : new File(outputDirectory, templateName);
        File templateFile = new File(this.templateDirectory, templateName);
        InputStream templateStream = templateFile.exists() ? new FileInputStream(templateFile) : this.getClass().getClassLoader().getResourceAsStream(templateName);
        if (templateStream == null) return;
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            InputStream is = templateStream;
            try {
                try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(target));){
                    InputStreamReader reader = new InputStreamReader(is);
                    Mustache mustache = mf.compile((Reader)reader, "project");
                    mustache.execute((Writer)writer, new Object[]{context}).flush();
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

