/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins.config;

import com.google.common.collect.Lists;
import io.provis.jenkins.config.JenkinsConfigRuntimeProvisioner;
import io.provis.jenkins.config.Template;
import io.provis.jenkins.runtime.JenkinsRuntime;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MasterConfiguration
implements Closeable {
    private final JenkinsRuntime runtime;
    private final File outputDirectory;
    private final File templateDirectory;
    private final List<String> templates;
    private final Properties properties;
    private final List<JenkinsRuntime.UsernamePassword> usernamePasswordCredentials;
    private final List<JenkinsRuntime.SecretCredential> secretCredentials;
    private final List<JenkinsRuntime.GitHubCredential> gitHubCredentials;

    public MasterConfiguration(JenkinsRuntime runtime, File templateDirectory, List<String> templates, File outputDirectory, Properties properties, List<JenkinsRuntime.UsernamePassword> usernamePasswordCredentials, List<JenkinsRuntime.SecretCredential> secretCredentials, List<JenkinsRuntime.GitHubCredential> gitHubCredentials) {
        this.runtime = runtime;
        this.templateDirectory = templateDirectory;
        this.templates = templates;
        this.outputDirectory = outputDirectory;
        this.usernamePasswordCredentials = usernamePasswordCredentials;
        this.secretCredentials = secretCredentials;
        this.gitHubCredentials = gitHubCredentials;
        this.properties = properties;
    }

    public void write() throws IOException {
        this.runtime.writeCredentials(new JenkinsRuntime.CredentialContainer(this.secretCredentials, this.usernamePasswordCredentials, this.gitHubCredentials));
        this.writeGlobalConfiguration();
    }

    @Override
    public void close() throws IOException {
        this.runtime.close();
    }

    private void writeGlobalConfiguration() throws IOException {
        this.outputDirectory.mkdirs();
        if (this.properties != null) {
            HashSet<Object> keys = new HashSet<Object>(this.properties.keySet());
            for (Object k : keys) {
                if (!(k instanceof String)) continue;
                this.properties.put(k + ".encrypted", this.runtime.encrypt(k.toString()));
            }
        }
        Template template = new Template(this.templateDirectory);
        if (this.templates != null) {
            for (String templateName : this.templates) {
                template.fromTemplate(templateName, this.properties, this.outputDirectory);
            }
        }
        for (String templateName : this.collectTemplates()) {
            if (this.templates != null || this.templates.contains(templateName)) continue;
            template.fromTemplate(templateName, this.properties, this.outputDirectory);
        }
    }

    private Collection<String> collectTemplates() {
        if (this.templateDirectory != null) {
            ArrayList<String> templates = new ArrayList<String>();
            LinkedList<File> q = new LinkedList<File>();
            q.add(this.templateDirectory);
            while (!q.isEmpty()) {
                File dir = (File)q.remove();
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        q.add(f);
                    } else {
                        String path = f.toURI().relativize(this.templateDirectory.toURI()).getPath();
                        templates.add(path);
                    }
                    ++n2;
                }
            }
            return templates;
        }
        return Collections.emptyList();
    }

    public static MasterConfigurationBuilder builder() {
        return new MasterConfigurationBuilder();
    }

    public static class MasterConfigurationBuilder {
        JenkinsConfigRuntimeProvisioner provisioner;
        File templateDirectory;
        List<String> templates = Lists.newArrayList();
        File outputDirectory;
        Properties properties;
        byte[] secretKey;
        List<JenkinsRuntime.UsernamePassword> usernamePasswordCredentials = Lists.newArrayList();
        List<JenkinsRuntime.SecretCredential> secretCredentials = Lists.newArrayList();
        List<JenkinsRuntime.GitHubCredential> gitHubCredentials = Lists.newArrayList();

        public MasterConfigurationBuilder outputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public MasterConfigurationBuilder properties(File propertiesFile) throws IOException {
            Properties properties = new Properties();
            if (propertiesFile != null && propertiesFile.exists()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (FileInputStream is = new FileInputStream(propertiesFile);){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.properties = properties;
            return this;
        }

        public MasterConfigurationBuilder provisioner(JenkinsConfigRuntimeProvisioner provisioner) {
            this.provisioner = provisioner;
            return this;
        }

        public MasterConfigurationBuilder secretKey(byte[] secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public MasterConfigurationBuilder templates(File templateDirectory) {
            this.templateDirectory = templateDirectory;
            return this;
        }

        public MasterConfigurationBuilder templates(String ... templates) {
            Collections.addAll(this.templates, templates);
            return this;
        }

        public MasterConfigurationBuilder templates(Collection<String> templates) {
            this.templates.addAll(templates);
            return this;
        }

        public MasterConfigurationBuilder properties(Properties properties) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)properties);
            this.properties = props;
            return this;
        }

        public MasterConfigurationBuilder usernamePasswordCredential(String id, String username, String password) {
            this.usernamePasswordCredentials.add(new JenkinsRuntime.UsernamePassword(id, username, password));
            return this;
        }

        public MasterConfigurationBuilder secretCredential(String id, String secret) {
            this.secretCredentials.add(new JenkinsRuntime.SecretCredential(id, secret));
            return this;
        }

        public MasterConfigurationBuilder gitHubCredential(String id, String username, String oauthToken, String gitHubApiUrl) {
            this.gitHubCredentials.add(new JenkinsRuntime.GitHubCredential(id, username, oauthToken, gitHubApiUrl));
            return this;
        }

        public MasterConfigurationBuilder usernamePasswordCredentials(Collection<JenkinsRuntime.UsernamePassword> credentials) {
            this.usernamePasswordCredentials.addAll(credentials);
            return this;
        }

        public MasterConfigurationBuilder secretCredentials(Collection<JenkinsRuntime.SecretCredential> credentials) {
            this.secretCredentials.addAll(credentials);
            return this;
        }

        public MasterConfigurationBuilder gitHubCredentials(Collection<JenkinsRuntime.GitHubCredential> credentials) {
            this.gitHubCredentials.addAll(credentials);
            return this;
        }

        public MasterConfiguration build(JenkinsRuntime runtime) throws IOException {
            return new MasterConfiguration(runtime, this.templateDirectory, this.templates, this.outputDirectory, this.properties, this.usernamePasswordCredentials, this.secretCredentials, this.gitHubCredentials);
        }

        public MasterConfiguration build() throws IOException {
            byte[] key;
            if (this.secretKey == null) {
                key = new byte[32];
                SecureRandom sr = new SecureRandom();
                sr.nextBytes(key);
            } else {
                key = this.secretKey;
            }
            JenkinsConfigRuntimeProvisioner p = this.provisioner;
            if (p == null) {
                p = new JenkinsConfigRuntimeProvisioner();
            }
            return this.build(p.provision(this.outputDirectory, key));
        }
    }
}

