/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins.config;

import io.provis.SimpleProvisioner;
import io.provis.jenkins.runtime.JenkinsRuntime;
import io.provis.jenkins.runtime.JenkinsRuntimeSPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.inject.Named;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

@Named(value="jenkins")
public class JenkinsConfigRuntimeProvisioner
extends SimpleProvisioner {
    public static final String ID = "jenkins";
    private static final String DEFAULT_RUNTIME;

    static {
        Properties config = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = JenkinsConfigRuntimeProvisioner.class.getResourceAsStream("/config.properties");){
                config.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading config.properties", e);
        }
        DEFAULT_RUNTIME = config.getProperty("defaultRuntime");
    }

    public JenkinsConfigRuntimeProvisioner() {
        this(DEFAULT_LOCAL_REPO, "http://repo1.maven.org/maven2");
    }

    public JenkinsConfigRuntimeProvisioner(File localRepo, String remoteRepo) {
        super(localRepo, remoteRepo);
    }

    public JenkinsRuntime provision(File rootDir, byte[] secretKey) throws IOException {
        return this.provision(rootDir, DEFAULT_RUNTIME, secretKey);
    }

    public JenkinsRuntime provision(File rootDir, String runtimeCoordinates, byte[] secretKey) throws IOException {
        ClassRealm realm;
        File runtimeJar = this.resolveFromRepository(runtimeCoordinates);
        final ClassWorld cw = new ClassWorld();
        try {
            realm = cw.newRealm("jenkins-config-runtime", null);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            return null;
        }
        realm.setParentClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        realm.addURL(runtimeJar.toURI().toURL());
        try {
            JenkinsRuntime runtime;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)realm);
                JenkinsRuntimeSPI spi = ServiceLoader.load(JenkinsRuntimeSPI.class, (ClassLoader)realm).iterator().next();
                runtime = spi.createRuntime(rootDir, secretKey);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            return new JenkinsRuntime(){

                public void close() throws IOException {
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
                        runtime.close();
                    }
                    catch (Throwable throwable) {
                        Thread.currentThread().setContextClassLoader(ccl);
                        try {
                            cw.disposeRealm(realm.getId());
                        }
                        catch (NoSuchRealmException noSuchRealmException) {}
                        throw throwable;
                    }
                    Thread.currentThread().setContextClassLoader(ccl);
                    try {
                        cw.disposeRealm(realm.getId());
                    }
                    catch (NoSuchRealmException noSuchRealmException) {}
                }

                public void writeCredentials(JenkinsRuntime.CredentialContainer creds) throws IOException {
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
                        runtime.writeCredentials(creds);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(ccl);
                    }
                }

                public String encrypt(String value) {
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
                        String string = runtime.encrypt(value);
                        return string;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(ccl);
                    }
                }
            };
        }
        catch (Throwable e) {
            try {
                cw.disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {}
            throw e;
        }
    }
}

