/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.provis.SimpleProvisioner;
import io.provis.jenkins.JenkinsProvisioningContext;
import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Named;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.swizzle.stream.ReplaceVariablesInputStream;

@Named(value="jenkins")
public class JenkinsProvisioner
extends SimpleProvisioner {
    public static final String ID = "jenkins";
    private static final String JENKINS_CENTRAL = "http://repo.jenkins-ci.org/public";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File provision(JenkinsProvisioningContext context) throws IOException {
        File jenkinsWar;
        File workDirectory;
        File installationDirectory;
        block19: {
            String version = context.getVersion();
            installationDirectory = context.getInstallationDirectory();
            workDirectory = context.getWorkDirectory();
            if (version.length() <= 0) {
                throw new IllegalArgumentException("Jenkins version not specified");
            }
            String repositoryUrl = context.getRepositoryUrl();
            if (repositoryUrl == null) {
                repositoryUrl = JENKINS_CENTRAL;
            }
            jenkinsWar = this.resolveFromServer(String.format("%s/org/jenkins-ci/main/jenkins-war/%s/jenkins-war-%s.war", repositoryUrl, version, version), "org.jenkins-ci.main:jenkins-war:war:" + context.getVersion());
            FileUtils.mkdir((String)installationDirectory.getAbsolutePath());
            FileUtils.mkdir((String)workDirectory.getAbsolutePath());
            Files.copy((File)jenkinsWar, (File)new File(installationDirectory, jenkinsWar.getName()));
            File jenkinsScript = new File(installationDirectory, "jenkins.sh");
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                InputStream is = JenkinsProvisioner.class.getClassLoader().getResourceAsStream("scripts/jenkins.sh");
                try {
                    try (FileOutputStream os = new FileOutputStream(jenkinsScript);){
                        if (is != null) {
                            HashMap variables = Maps.newHashMap();
                            variables.put("PORT", String.valueOf(context.getPort()));
                            ReplaceVariablesInputStream replace = new ReplaceVariablesInputStream(is, "@", "@", (Map)variables);
                            ByteStreams.copy((InputStream)replace, (OutputStream)os);
                            jenkinsScript.setExecutable(true);
                        }
                    }
                    if (is == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Set<String> bundledPluginIds = this.findBundledPluginIds(jenkinsWar);
        UnArchiver unarchiver = UnArchiver.builder().build();
        Iterator<String> iterator = context.getPlugins().iterator();
        while (iterator.hasNext()) {
            String plugin = iterator.next();
            File pluginsDirectory = new File(workDirectory, "plugins");
            File pluginFile = this.resolveFromRepository(JENKINS_CENTRAL, plugin);
            FileUtils.mkdir((String)pluginsDirectory.getAbsolutePath());
            String pluginId = pluginFile.getName().substring(0, pluginFile.getName().lastIndexOf("-"));
            String pluginFileNameWithoutVersion = String.valueOf(pluginId) + ".jpi";
            File pluginFileWithoutVersion = new File(pluginsDirectory, pluginFileNameWithoutVersion);
            Files.copy((File)pluginFile, (File)pluginFileWithoutVersion);
            if (bundledPluginIds.contains(pluginId)) {
                String pinnedName = String.valueOf(pluginId) + ".jpi.pinned";
                File pinned = new File(pluginsDirectory, pinnedName);
                Files.touch((File)pinned);
            }
            File pluginDirectory = new File(pluginsDirectory, pluginId);
            unarchiver.unarchive(pluginFileWithoutVersion, pluginDirectory);
        }
        return installationDirectory;
    }

    public Set<String> findBundledPluginIds(File jenkinsWar) throws IOException {
        HashSet bundledPluginIds = Sets.newHashSet();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile file = new ZipFile(jenkinsWar);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("WEB-INF/plugins/") || !name.endsWith(".hpi")) continue;
                name = name.substring(name.lastIndexOf("/") + 1);
                name = name.substring(0, name.lastIndexOf("."));
                bundledPluginIds.add(name);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bundledPluginIds;
    }
}

