/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins;

import io.provis.jenkins.JenkinsProvisioningContext;
import io.provis.nexus.Command;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class JenkinsLauncher {
    private File installationDirectory;
    private File jenkinsWar;
    private File workDirectory;
    private int port;
    private Commandline cl;
    private Command command;

    public JenkinsLauncher(JenkinsProvisioningContext context) throws Exception {
        this.installationDirectory = context.getInstallationDirectory();
        this.jenkinsWar = new File(this.installationDirectory, String.format("jenkins-war-%s.war", context.getVersion()));
        this.workDirectory = context.getWorkDirectory();
        this.port = context.getPort();
    }

    public void start() throws Exception {
        FileUtils.mkdir((String)this.workDirectory.getAbsolutePath());
        this.cl = new Commandline();
        this.cl.setWorkingDirectory(this.installationDirectory);
        this.cl.addArguments(new String[]{"java", "-Xms256m", "-Xmx1024m"});
        this.cl.addArguments(this.getVMArguments());
        this.cl.addArguments(new String[]{"-jar", this.jenkinsWar.getAbsolutePath(), String.format("--httpPort=%s", this.port)});
        this.command = new Command(this.cl.getArguments()).setDirectory(this.installationDirectory);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        this.command.execute((Executor)executor);
        System.out.println("Attempting to determine if Jenkins is ready!");
        while (!this.readyToRespondToRequests()) {
            Thread.sleep(3000L);
        }
    }

    public void stop() throws Exception {
        this.command.stop();
    }

    public String[] classpath() throws Exception {
        String pathSeparator = System.getProperty("path.separator");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = this.getClasspath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s).append(pathSeparator);
            ++n2;
        }
        return new String[]{sb.toString()};
    }

    public String[] getClasspath() throws Exception {
        String path;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.installationDirectory);
        ds.setIncludes(new String[]{"lib/*.jar", "conf"});
        ds.scan();
        ArrayList<String> cp = new ArrayList<String>();
        String[] stringArray = ds.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            cp.add(path);
            ++n2;
        }
        stringArray = ds.getIncludedDirectories();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            cp.add(path);
            ++n2;
        }
        return cp.toArray(new String[cp.size()]);
    }

    public String[] getVMArguments() throws Exception {
        return new String[]{"-DJENKINS_HOME=" + this.quote(this.workDirectory)};
    }

    private String quote(File file) {
        return StringUtils.quoteAndEscape((String)file.getAbsolutePath(), (char)'\"');
    }

    private boolean readyToRespondToRequests() {
        HttpURLConnection connection = null;
        try {
            URL serverAddress = new URL(String.format("http://localhost:%s", this.port));
            connection = (HttpURLConnection)serverAddress.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(2000);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            connection.disconnect();
            connection = null;
        }
        return true;
    }
}

