/*
 * Decompiled with CFR 0.152.
 */
package io.provis.jenkins.runtime;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public interface JenkinsRuntime
extends Closeable {
    public void writeCredentials(CredentialContainer var1) throws IOException;

    public String encrypt(String var1);

    public static class CredentialContainer {
        private List<SecretCredential> secretCredentials;
        private List<UsernamePassword> usernamePasswordCredentials;
        private List<GitHubCredential> gitHubCredentials;

        public CredentialContainer(List<SecretCredential> secretCredentials, List<UsernamePassword> usernamePasswordCredentials, List<GitHubCredential> gitHubCredentials) {
            this.secretCredentials = secretCredentials;
            this.usernamePasswordCredentials = usernamePasswordCredentials;
            this.gitHubCredentials = gitHubCredentials;
        }

        public List<SecretCredential> getSecretCredentials() {
            return this.secretCredentials;
        }

        public List<UsernamePassword> getUsernamePasswordCredentials() {
            return this.usernamePasswordCredentials;
        }

        public List<GitHubCredential> getGitHubCredentials() {
            return this.gitHubCredentials;
        }
    }

    public static class GitHubCredential {
        private final String id;
        private final String username;
        private final String oauthToken;
        private final String gitHubApiUrl;

        public GitHubCredential(String id, String username, String oauthToken, String gitHubApiUrl) {
            this.id = id;
            this.username = username;
            this.oauthToken = oauthToken;
            this.gitHubApiUrl = gitHubApiUrl;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getOauthToken() {
            return this.oauthToken;
        }

        public String getGitHubApiUrl() {
            return this.gitHubApiUrl;
        }
    }

    public static class SecretCredential {
        private final String id;
        private final String secret;

        public SecretCredential(String id, String secret) {
            this.id = id;
            this.secret = secret;
        }

        public String getId() {
            return this.id;
        }

        public String getSecret() {
            return this.secret;
        }
    }

    public static class UsernamePassword {
        private final String id;
        private final String username;
        private final String password;

        public UsernamePassword(String id, String username, String password) {
            this.id = id;
            this.username = username;
            this.password = password;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

