/*
 * Decompiled with CFR 0.152.
 */
package io.provis.perms;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public final class PosixModes {
    static final PosixFilePermission[] PERMISSIONS = PosixFilePermission.values();
    private static final int PERMISSIONS_LENGTH = PERMISSIONS.length;
    private static final int INT_MODE_MAX = (1 << PERMISSIONS_LENGTH) - 1;

    private PosixModes() {
        throw new Error("nice try!");
    }

    public static Set<PosixFilePermission> intModeToPosix(int intMode) {
        if ((intMode & INT_MODE_MAX) != intMode) {
            throw new RuntimeException("Invalid intMode: " + intMode);
        }
        EnumSet<PosixFilePermission> set = EnumSet.noneOf(PosixFilePermission.class);
        int i = 0;
        while (i < PERMISSIONS_LENGTH) {
            if ((intMode & 1) == 1) {
                set.add(PERMISSIONS[PERMISSIONS_LENGTH - i - 1]);
            }
            intMode >>= 1;
            ++i;
        }
        return set;
    }
}

