/*
 * Decompiled with CFR 0.152.
 */
package io.provis.action.fileset;

import io.provis.model.ProvisioningAction;
import io.provis.model.ProvisioningContext;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.util.FileUtils;

@Named(value="executable")
public class MakeExecutableAction
implements ProvisioningAction {
    private String includes;
    private String excludes;
    private File fileSetDirectory;
    private File runtimeDirectory;

    public void execute(ProvisioningContext context) throws Exception {
        if (this.fileSetDirectory.exists()) {
            try {
                List filePaths = FileUtils.getFileNames((File)this.fileSetDirectory, (String)this.includes, (String)this.excludes, (boolean)true);
                for (String filePath : filePaths) {
                    File file = new File(filePath);
                    file.setExecutable(true);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public File getFileSetDirectory() {
        return this.fileSetDirectory;
    }

    public void setFileSetDirectory(File fileSetDirectory) {
        this.fileSetDirectory = fileSetDirectory;
    }

    public File getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public void setRuntimeDirectory(File runtimeDirectory) {
        this.runtimeDirectory = runtimeDirectory;
    }
}

