/*
 * Decompiled with CFR 0.152.
 */
package io.provis.action.artifact;

import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningAction;
import io.provis.model.ProvisioningContext;
import io.provis.model.io.InterpolatingInputStream;
import io.tesla.proviso.archive.Selector;
import io.tesla.proviso.archive.UnArchiver;
import io.tesla.proviso.archive.UnarchivingEntryProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;

@Named(value="unpack")
public class UnpackAction
implements ProvisioningAction {
    private String includes;
    private String excludes;
    private boolean useRoot;
    private boolean flatten;
    private boolean filter;
    private String filterIncludes;
    private ProvisioArtifact artifact;
    private File outputDirectory;
    private static final Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public void execute(ProvisioningContext context) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File archive = this.artifact.getFile();
        try {
            UnArchiver unarchiver = UnArchiver.builder().includes(this.split(this.includes)).excludes(this.split(this.excludes)).useRoot(this.useRoot).flatten(this.flatten).build();
            if (this.filter) {
                if (this.filterIncludes != null) {
                    unarchiver.unarchive(archive, this.outputDirectory, (UnarchivingEntryProcessor)new SelectiveFilteringProcessor(splitter.splitToList((CharSequence)this.includes), null, context.getVariables()));
                } else {
                    unarchiver.unarchive(archive, this.outputDirectory, (UnarchivingEntryProcessor)new FilteringProcessor(context.getVariables()));
                }
            } else {
                unarchiver.unarchive(archive, this.outputDirectory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] split(String s) {
        if (s == null) {
            return new String[0];
        }
        return StringUtils.split((String)s, (String)",");
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isUseRoot() {
        return this.useRoot;
    }

    public void setUseRoot(boolean useRoot) {
        this.useRoot = useRoot;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public ProvisioArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ProvisioArtifact artifact) {
        this.artifact = artifact;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    class FilteringProcessor
    implements UnarchivingEntryProcessor {
        Selector selector;
        Map<String, String> variables;

        FilteringProcessor(Map<String, String> variables) {
            this.variables = variables;
        }

        public String processName(String name) {
            return name;
        }

        public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)new InterpolatingInputStream(inputStream, this.variables), (OutputStream)outputStream);
        }
    }

    class SelectiveFilteringProcessor
    implements UnarchivingEntryProcessor {
        Selector selector;
        Map<String, String> variables;

        SelectiveFilteringProcessor(List<String> includes, List<String> excludes, Map<String, String> variables) {
            this.variables = variables;
            this.selector = new Selector(includes, excludes);
        }

        public String processName(String name) {
            return name;
        }

        public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
            if (this.selector.include(entryName)) {
                ByteStreams.copy((InputStream)new InterpolatingInputStream(inputStream, this.variables), (OutputStream)outputStream);
            } else {
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
    }
}

