/*
 * Decompiled with CFR 0.152.
 */
package io.provis;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.provis.Lookup;
import io.provis.ProvisioningException;
import io.provis.action.artifact.WriteToDiskAction;
import io.provis.model.ArtifactSet;
import io.provis.model.Directory;
import io.provis.model.Exclusion;
import io.provis.model.File;
import io.provis.model.FileSet;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningAction;
import io.provis.model.ProvisioningContext;
import io.provis.model.ProvisioningRequest;
import io.provis.model.ProvisioningResult;
import io.provis.model.Resource;
import io.provis.model.ResourceSet;
import io.provis.model.Runtime;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;

public class MavenProvisioner {
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private List<RemoteRepository> remoteRepositories;
    static Joiner joiner = Joiner.on((char)',').skipNulls();
    Lookup lookup = new Lookup();

    public MavenProvisioner(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    public ProvisioningResult provision(ProvisioningRequest request) throws Exception {
        ProvisioningResult result = new ProvisioningResult(request);
        ProvisioningContext context = new ProvisioningContext(request, result);
        this.processArtifactSets(context);
        this.processResourceSets(context);
        this.processFileSets(context);
        this.processRuntimeActions(context);
        return result;
    }

    private void processArtifactSets(ProvisioningContext context) throws Exception {
        for (ArtifactSet artifactSet : context.getRequest().getRuntimeModel().getArtifactSets()) {
            this.processArtifactSet(context, artifactSet);
        }
    }

    private void processArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        this.resolveArtifactSetOutputDirectory(context, artifactSet);
        this.resolveArtifactSet(context, artifactSet);
        this.processArtifactsWithActions(context, artifactSet);
        this.processArtifactSetActions(context, artifactSet);
        if (artifactSet.getArtifactSets() != null) {
            for (ArtifactSet childFileSet : artifactSet.getArtifactSets()) {
                this.processArtifactSet(context, childFileSet);
            }
        }
    }

    private void resolveArtifactSetOutputDirectory(ProvisioningContext context, ArtifactSet artifactSet) {
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            artifactSet.setOutputDirectory(new java.io.File(parent.getOutputDirectory(), artifactSet.getDirectory()));
        } else if (artifactSet.getDirectory().equals("root") || artifactSet.getDirectory().equals("/")) {
            artifactSet.setOutputDirectory(context.getRequest().getOutputDirectory());
        } else {
            artifactSet.setOutputDirectory(new java.io.File(context.getRequest().getOutputDirectory(), artifactSet.getDirectory()));
        }
        if (!artifactSet.getOutputDirectory().exists()) {
            artifactSet.getOutputDirectory().mkdirs();
        }
    }

    private void processArtifactSetActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
    }

    private void processArtifactsWithActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        for (ProvisioArtifact artifact : artifactSet.getResolvedArtifacts()) {
            WriteToDiskAction action2;
            if (artifact.getActions() != null) {
                for (WriteToDiskAction action2 : artifact.getActions()) {
                    this.configureArtifactAction(artifact, action2, artifactSet.getOutputDirectory());
                    action2.execute(context);
                }
                continue;
            }
            action2 = new WriteToDiskAction(artifact, artifactSet.getOutputDirectory());
            action2.execute(context);
        }
    }

    private Set<ProvisioArtifact> resolveArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) {
        List artifacts;
        if (artifactSet.getReference() != null) {
            Runtime runtime = context.getRequest().getRuntimeModel();
            if (runtime.getArtifactSetReferences() == null) {
                throw new RuntimeException(String.format("The reference '%s' is being requested but the artifactSet references are null.", artifactSet.getReference()));
            }
            ArtifactSet referenceArtifactSet = (ArtifactSet)runtime.getArtifactSetReferences().get(artifactSet.getReference());
            if (referenceArtifactSet == null) {
                throw new RuntimeException(String.format("The is no '%s' artifactSet reference available.", artifactSet.getReference()));
            }
            artifacts = referenceArtifactSet.getArtifacts();
        } else {
            artifacts = artifactSet.getArtifacts();
        }
        HashSet parentResolved = artifactSet.getParent() != null ? artifactSet.getParent().getResolvedArtifacts() : Sets.newHashSet();
        Set<ProvisioArtifact> resolvedArtifacts = this.resolveArtifacts(context, artifacts, parentResolved, artifactSet.getExcludes());
        artifactSet.setResolvedArtifacts(resolvedArtifacts);
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            Set parentArtifacts = artifactSet.getParent().getResolvedArtifacts();
            Sets.SetView childResolvedArtifacts = Sets.difference(resolvedArtifacts, (Set)parentArtifacts);
            artifactSet.setResolvedArtifacts((Set)childResolvedArtifacts);
        } else {
            artifactSet.setResolvedArtifacts(resolvedArtifacts);
        }
        return resolvedArtifacts;
    }

    public Set<ProvisioArtifact> resolveArtifact(ProvisioningContext context, ProvisioArtifact artifact) {
        return this.resolveArtifacts(context, (List<ProvisioArtifact>)ImmutableList.of((Object)artifact), Sets.newHashSet(), Lists.newArrayList());
    }

    private Set<ProvisioArtifact> resolveArtifacts(ProvisioningContext context, List<ProvisioArtifact> artifacts, Set<ProvisioArtifact> managedArtifacts, List<Exclusion> excludes) {
        List<Artifact> resultArtifacts;
        CollectRequest request = new CollectRequest();
        if (artifacts == null) {
            artifacts = Lists.newArrayList();
        }
        if (managedArtifacts == null) {
            managedArtifacts = Sets.newHashSet();
        }
        ArrayList providedArtifacts = Lists.newArrayList();
        for (ProvisioArtifact artifact : artifacts) {
            if (artifact.getReference() != null) {
                Runtime runtime = context.getRequest().getRuntimeModel();
                if (runtime.getArtifactReferences() == null) {
                    throw new RuntimeException(String.format("The reference '%s' is being requested but the artifact references are null.", artifact.getReference()));
                }
                ProvisioArtifact referenceArtifact = (ProvisioArtifact)runtime.getArtifactReferences().get(artifact.getReference());
                if (referenceArtifact == null) {
                    throw new RuntimeException(String.format("The is no '%s' artifact reference available.", artifact.getReference()));
                }
                if (artifact.getName() != null) {
                    referenceArtifact.setName(artifact.getName());
                }
                providedArtifacts.add(referenceArtifact);
                continue;
            }
            if (artifact.getFile() != null) {
                providedArtifacts.add(artifact);
                continue;
            }
            DefaultArtifactType type = null;
            if (artifact.getExtension().equals("tar.gz")) {
                type = new DefaultArtifactType("tar.gz", "tar.gz", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("zip")) {
                type = new DefaultArtifactType("zip", "zip", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("war")) {
                type = new DefaultArtifactType("war", "war", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("hpi")) {
                type = new DefaultArtifactType("hpi", "hpi", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("jpi")) {
                type = new DefaultArtifactType("jpi", "jpi", "", "packaging", false, true);
            }
            if (this.getArtifactType(artifact.getExtension()) == null) {
                type = new DefaultArtifactType(artifact.getExtension(), artifact.getExtension(), "", "unknown", false, true);
            }
            if (type != null) {
                artifact.setProperties(type.getProperties());
            }
            Dependency dependency = new Dependency((Artifact)artifact, "runtime");
            if (artifact.getExclusions() != null) {
                HashSet exclusions = Sets.newHashSet();
                for (String exclusion : artifact.getExclusions()) {
                    String[] ga = StringUtils.split((String)exclusion, (String)":");
                    if (ga.length == 2) {
                        exclusions.add(new org.eclipse.aether.graph.Exclusion(ga[0], ga[1], "*", "*"));
                        continue;
                    }
                    if (ga.length != 1) continue;
                    exclusions.add(new org.eclipse.aether.graph.Exclusion(null, ga[0], "*", "*"));
                }
                dependency = dependency.setExclusions((Collection)exclusions);
            }
            request.addDependency(dependency);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(request, null);
        if (excludes != null) {
            ArrayList exclusions = Lists.newArrayList();
            for (Exclusion exclusion : excludes) {
                exclusions.add(exclusion.getId());
            }
            dependencyRequest.setFilter((DependencyFilter)new ExclusionsDependencyFilter((Collection)exclusions));
        }
        for (String coordinate : context.getRequest().getManagedDependencies()) {
            ProvisioArtifact artifact = new ProvisioArtifact(coordinate);
            request.addManagedDependency(new Dependency((Artifact)artifact, "runtime"));
        }
        for (Artifact artifact : managedArtifacts) {
            request.addManagedDependency(new Dependency(artifact, "runtime"));
        }
        try {
            resultArtifacts = this.resolveArtifacts(dependencyRequest);
            resultArtifacts.addAll(providedArtifacts);
        }
        catch (DependencyResolutionException e) {
            throw new ProvisioningException(e.getMessage(), e);
        }
        HashMap<String, ProvisioArtifact> artifactMapKeyedByGa = new HashMap<String, ProvisioArtifact>();
        HashSet resolvedArtifacts = Sets.newHashSet();
        for (Artifact a : resultArtifacts) {
            String ga = String.valueOf(a.getGroupId()) + ":" + a.getArtifactId();
            if (a instanceof ProvisioArtifact) {
                artifactMapKeyedByGa.put(ga, (ProvisioArtifact)a);
                resolvedArtifacts.add((ProvisioArtifact)a);
                continue;
            }
            artifactMapKeyedByGa.put(ga, new ProvisioArtifact(a));
            resolvedArtifacts.add(new ProvisioArtifact(a));
        }
        return resolvedArtifacts;
    }

    private List<Artifact> resolveArtifacts(DependencyRequest request) throws DependencyResolutionException {
        CollectRequest collectRequest = request.getCollectRequest();
        if (collectRequest.getRepositories() == null || collectRequest.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepository);
            }
        }
        DependencyResult result = this.repositorySystem.resolveDependencies(this.repositorySystemSession, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactResult ar : result.getArtifactResults()) {
            artifacts.add(ar.getArtifact());
        }
        return artifacts;
    }

    private ArtifactType getArtifactType(String typeId) {
        return this.repositorySystemSession.getArtifactTypeRegistry().get(typeId);
    }

    private void processResourceSets(ProvisioningContext context) throws Exception {
        List resourceSets = context.getRequest().getRuntime().getResourceSets();
        if (resourceSets != null) {
            for (ResourceSet resourceSet : resourceSets) {
                for (Resource resource : resourceSet.getResources()) {
                    java.io.File source = new java.io.File(resource.getName());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    java.io.File target = new java.io.File(context.getRequest().getOutputDirectory(), source.getName());
                    this.copy(source, target);
                }
            }
        }
    }

    private void processFileSets(ProvisioningContext context) throws Exception {
        List fileSets = context.getRequest().getRuntime().getFileSets();
        if (fileSets != null) {
            for (FileSet fileSet : fileSets) {
                for (File file : fileSet.getFiles()) {
                    if (file.getTouch() != null) {
                        java.io.File target = new java.io.File(new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory()), file.getTouch());
                        if (!target.getParentFile().exists()) {
                            target.getParentFile().mkdirs();
                        }
                        Files.createFile(target.toPath(), new FileAttribute[0]);
                        continue;
                    }
                    java.io.File source = new java.io.File(file.getPath());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    java.io.File target = new java.io.File(new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory()), source.getName());
                    this.copy(source, target);
                }
                for (Directory directory : fileSet.getDirectories()) {
                    java.io.File sourceDirectory = new java.io.File(directory.getPath());
                    java.io.File targetDirectory = new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory());
                    this.copyDirectoryStructure(sourceDirectory, targetDirectory, directory.getIncludes(), directory.getExcludes());
                }
            }
        }
    }

    private void copyDirectoryStructure(java.io.File sourceDirectory, java.io.File targetDirectory, List<String> includes, List<String> excludes) throws IOException {
        String includesString = null;
        if (includes != null && !includes.isEmpty()) {
            includesString = joiner.join(includes);
        }
        String excludesString = null;
        if (excludes != null && !excludes.isEmpty()) {
            excludesString = joiner.join(excludes);
        }
        List relativePaths = FileUtils.getFileNames((java.io.File)sourceDirectory, (String)includesString, excludesString, (boolean)false);
        for (String relativePath : relativePaths) {
            java.io.File source = new java.io.File(sourceDirectory, relativePath);
            java.io.File target = new java.io.File(targetDirectory, relativePath);
            this.copy(source, target);
        }
    }

    private void copy(java.io.File source, java.io.File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    private void processRuntimeActions(ProvisioningContext context) throws Exception {
        List runtimeActions = context.getRequest().getRuntime().getActions();
        if (runtimeActions != null) {
            for (ProvisioningAction action : runtimeActions) {
                this.configureArtifactSetAction(action, context.getRequest().getOutputDirectory());
                action.execute(context);
            }
        }
    }

    private void configureArtifactSetAction(ProvisioningAction provisioningAction, java.io.File outputDirectory) {
        this.lookup.setObjectProperty(provisioningAction, "fileSetDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "outputDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "runtimeDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "provisioner", this);
    }

    private void configureArtifactAction(ProvisioArtifact artifact, ProvisioningAction provisioningAction, java.io.File outputDirectory) {
        this.lookup.setObjectProperty(provisioningAction, "artifact", artifact);
        this.lookup.setObjectProperty(provisioningAction, "fileSetDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "outputDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "provisioner", this);
    }
}

